/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.server.support.EnvironmentRepositoryProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="spring.cloud.config.server.awsparamstore")
public class AwsParameterStoreEnvironmentProperties
implements EnvironmentRepositoryProperties {
    static final String DEFAULT_PATH_SEPARATOR = "/";
    private static final String DEFAULT_ORIGIN = "aws:ssm:parameter:";
    private static final String DEFAULT_PREFIX = "/config";
    private static final String DEFAULT_PROFILE_SEPARATOR = "-";
    private int order = Integer.MAX_VALUE;
    private String region;
    private String endpoint;
    @NotNull
    private String origin = "aws:ssm:parameter:";
    @NotNull
    @Pattern(regexp="(/[a-zA-Z0-9.\\-_]+)*")
    private @NotNull @Pattern(regexp="(/[a-zA-Z0-9.\\-_]+)*") String prefix = "/config";
    @NotBlank
    @Pattern(regexp="[a-zA-Z0-9.\\-_/]+")
    private @NotBlank @Pattern(regexp="[a-zA-Z0-9.\\-_/]+") String profileSeparator = "-";
    private boolean recursive = true;
    private boolean decryptValues = true;
    @Min(value=1L)
    @Max(value=10L)
    private @Min(value=1L) @Max(value=10L) int maxResults = 10;

    public int getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getProfileSeparator() {
        return this.profileSeparator;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public boolean isDecryptValues() {
        return this.decryptValues;
    }

    public void setDecryptValues(boolean decryptValues) {
        this.decryptValues = decryptValues;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }
}

