/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.encryption.EnvironmentPrefixHelper;
import org.springframework.cloud.config.server.encryption.ResourceEncryptor;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.util.StringUtils;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.json.JsonFactory;
import tools.jackson.dataformat.yaml.YAMLFactory;

abstract class AbstractCipherResourceEncryptor
implements ResourceEncryptor {
    protected final String CIPHER_MARKER = "{cipher}";
    private final TextEncryptorLocator encryptor;
    private EnvironmentPrefixHelper helper = new EnvironmentPrefixHelper();

    AbstractCipherResourceEncryptor(TextEncryptorLocator encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public abstract List<String> getSupportedExtensions();

    @Override
    public abstract String decrypt(String var1, Environment var2) throws IOException;

    protected String decryptWithJacksonParser(String text, String name, String[] profiles, JsonFactory factory) throws IOException {
        return this.decryptWithJacksonParser(text, name, profiles, factory.createParser(ObjectReadContext.empty(), text));
    }

    protected String decryptWithJacksonParser(String text, String name, String[] profiles, YAMLFactory factory) throws IOException {
        return this.decryptWithJacksonParser(text, name, profiles, factory.createParser(ObjectReadContext.empty(), text));
    }

    protected String decryptWithJacksonParser(String text, String name, String[] profiles, JsonParser parser) throws IOException {
        JsonToken token;
        HashSet<String> valsToDecrypt = new HashSet<String>();
        while ((token = parser.nextToken()) != null) {
            if (!token.equals((Object)JsonToken.VALUE_STRING) || !parser.getValueAsString().startsWith("{cipher}")) continue;
            valsToDecrypt.add(parser.getValueAsString().trim());
        }
        for (String value : valsToDecrypt) {
            String decryptedValue = this.decryptValue(value.replace("{cipher}", ""), name, profiles);
            text = text.replace(value, decryptedValue);
        }
        return text;
    }

    protected String decryptValue(String value, String name, String[] profiles) {
        return this.encryptor.locate(this.helper.getEncryptorKeys(name, StringUtils.arrayToCommaDelimitedString((Object[])profiles), value)).decrypt(this.helper.stripPrefix(value));
    }
}

