/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault;

import java.net.URI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.server.environment.ConfigTokenProvider;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.vault.SpringVaultClientAuthenticationProvider;
import org.springframework.cloud.config.server.environment.vault.StatelessSessionManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.StringUtils;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.client.RestTemplateBuilder;
import org.springframework.vault.client.RestTemplateCustomizer;
import org.springframework.vault.client.VaultClients;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.vault.config.AbstractVaultConfiguration;
import org.springframework.vault.support.SslConfiguration;
import org.springframework.vault.support.VaultToken;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Configuration
public class SpringVaultClientConfiguration
extends AbstractVaultConfiguration {
    private static final String VAULT_PROPERTIES_PREFIX = "spring.cloud.config.server.vault.";
    private final VaultEnvironmentProperties vaultProperties;
    private final ConfigTokenProvider configTokenProvider;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final List<SpringVaultClientAuthenticationProvider> authProviders;

    public SpringVaultClientConfiguration(VaultEnvironmentProperties vaultProperties, ConfigTokenProvider configTokenProvider, List<SpringVaultClientAuthenticationProvider> authProviders) {
        this.vaultProperties = vaultProperties;
        this.configTokenProvider = configTokenProvider;
        this.authProviders = authProviders;
    }

    public VaultEndpoint vaultEndpoint() {
        URI baseUrl = UriComponentsBuilder.newInstance().scheme(this.vaultProperties.getScheme()).host(this.vaultProperties.getHost()).port(this.vaultProperties.getPort().intValue()).build().toUri();
        return VaultEndpoint.from((URI)baseUrl);
    }

    protected RestTemplateBuilder restTemplateBuilder(VaultEndpointProvider endpointProvider, ClientHttpRequestFactory requestFactory) {
        RestTemplateBuilder restTemplateBuilder = super.restTemplateBuilder(endpointProvider, requestFactory);
        if (this.vaultProperties.getNamespace() != null) {
            restTemplateBuilder.customizers(new RestTemplateCustomizer[]{this::applyNamespaceInterceptor});
        }
        return restTemplateBuilder;
    }

    @Bean
    public SessionManager sessionManager() {
        if (this.vaultProperties.getAuthentication() == null && !StringUtils.hasText((String)this.vaultProperties.getToken())) {
            return new StatelessSessionManager(this.clientAuthentication());
        }
        return super.sessionManager();
    }

    public SslConfiguration sslConfiguration() {
        if (this.vaultProperties.isSkipSslValidation()) {
            this.log.warn((Object)"The 'spring.cloud.config.server.vault.skipSslValidation' property is not supported by this Vault environment repository implementation. Use the 'spring.cloud.config.server.vault.ssl` properties to provide custom keyStore and trustStore material instead.");
        }
        VaultEnvironmentProperties.Ssl ssl = this.vaultProperties.getSsl();
        SslConfiguration.KeyStoreConfiguration keyStoreConfiguration = this.getKeyStoreConfiguration(ssl.getKeyStore(), ssl.getKeyStorePassword());
        SslConfiguration.KeyStoreConfiguration trustStoreConfiguration = this.getKeyStoreConfiguration(ssl.getTrustStore(), ssl.getTrustStorePassword());
        return new SslConfiguration(keyStoreConfiguration, trustStoreConfiguration);
    }

    public RestOperations restOperations() {
        return this.restTemplateBuilder(this.vaultEndpointProvider(), this.clientHttpRequestFactoryWrapper().getClientHttpRequestFactory()).build();
    }

    private SslConfiguration.KeyStoreConfiguration getKeyStoreConfiguration(Resource resourceProperty, String passwordProperty) {
        if (resourceProperty == null) {
            return SslConfiguration.KeyStoreConfiguration.unconfigured();
        }
        if (StringUtils.hasText((String)passwordProperty)) {
            return SslConfiguration.KeyStoreConfiguration.of((Resource)resourceProperty, (char[])passwordProperty.toCharArray());
        }
        return SslConfiguration.KeyStoreConfiguration.of((Resource)resourceProperty);
    }

    private RestOperations applyNamespaceInterceptor(RestTemplate restTemplate) {
        if (this.vaultProperties.getNamespace() != null) {
            restTemplate.getInterceptors().add(VaultClients.createNamespaceInterceptor((String)this.vaultProperties.getNamespace()));
        }
        return restTemplate;
    }

    public ClientAuthentication clientAuthentication() {
        VaultEnvironmentProperties.AuthenticationMethod authentication = this.vaultProperties.getAuthentication();
        if (authentication == null) {
            return new ConfigTokenProviderAuthentication(this.configTokenProvider);
        }
        if (this.authProviders == null || this.authProviders.isEmpty()) {
            throw new UnsupportedOperationException("No Vault client authentication providers are configured");
        }
        RestTemplate externalOperations = new RestTemplate(this.clientHttpRequestFactoryWrapper().getClientHttpRequestFactory());
        for (SpringVaultClientAuthenticationProvider authProvider : this.authProviders) {
            if (!authProvider.supports(this.vaultProperties)) continue;
            return authProvider.getClientAuthentication(this.vaultProperties, this.restOperations(), (RestOperations)externalOperations);
        }
        throw new UnsupportedOperationException(String.format("Client authentication %s not supported", new Object[]{authentication}));
    }

    static class ConfigTokenProviderAuthentication
    implements ClientAuthentication {
        private final ConfigTokenProvider tokenProvider;

        ConfigTokenProviderAuthentication(ConfigTokenProvider tokenProvider) {
            this.tokenProvider = tokenProvider;
        }

        public VaultToken login() throws VaultException {
            String token = this.tokenProvider.getToken();
            if (!StringUtils.hasLength((String)token)) {
                throw new IllegalArgumentException("A Vault token must be supplied by a token provider");
            }
            return VaultToken.of((String)token);
        }
    }
}

