/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.JsonS3ConfigFile;
import org.springframework.cloud.config.server.environment.PropertyS3ConfigFile;
import org.springframework.cloud.config.server.environment.S3ConfigFile;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.cloud.config.server.environment.YamlS3ConfigFile;
import org.springframework.core.Ordered;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class AwsS3EnvironmentRepository
implements EnvironmentRepository,
Ordered,
SearchPathLocator {
    private static final Log LOG = LogFactory.getLog(AwsS3EnvironmentRepository.class);
    private static final String AWS_S3_RESOURCE_SCHEME = "s3://";
    private static final String PATH_SEPARATOR = "/";
    private final S3Client s3Client;
    private final String bucketName;
    private final ConfigServerProperties serverProperties;
    protected int order = Integer.MAX_VALUE;

    public AwsS3EnvironmentRepository(S3Client s3Client, String bucketName, ConfigServerProperties server) {
        this.s3Client = s3Client;
        this.bucketName = bucketName;
        this.serverProperties = server;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public Environment findOne(String specifiedApplication, String specifiedProfiles, String specifiedLabel) {
        List<String> labels;
        String application = ObjectUtils.isEmpty((Object)specifiedApplication) ? this.serverProperties.getDefaultApplicationName() : specifiedApplication;
        String profiles = ObjectUtils.isEmpty((Object)specifiedProfiles) ? this.serverProperties.getDefaultProfile() : specifiedProfiles;
        String label = ObjectUtils.isEmpty((Object)specifiedLabel) ? this.serverProperties.getDefaultLabel() : specifiedLabel;
        String[] profileArray = this.parseProfiles(profiles);
        List<String> apps = Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)application.replace(" ", "")));
        Collections.reverse(apps);
        if (!apps.contains(this.serverProperties.getDefaultApplicationName())) {
            apps = new ArrayList<String>(apps);
            apps.add(this.serverProperties.getDefaultApplicationName());
        }
        Environment environment = new Environment(application, profileArray);
        environment.setLabel(label);
        if (StringUtils.hasText((String)label) && label.contains(",")) {
            labels = Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)label));
            Collections.reverse(labels);
        } else {
            labels = Collections.singletonList(label);
        }
        for (String l : labels) {
            for (String profile : profileArray) {
                for (String app : apps) {
                    this.addPropertySource(environment, app, profile, l);
                }
            }
        }
        for (String l : labels) {
            for (String app : apps) {
                this.addPropertySource(environment, app, null, l);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning Environment: " + environment));
        }
        return environment;
    }

    private void addPropertySource(Environment environment, String app, String profile, String label) {
        S3ConfigFile s3ConfigFile = this.getS3ConfigFile(app, profile, label);
        if (s3ConfigFile != null) {
            environment.setVersion(s3ConfigFile.getVersion());
            Properties config = s3ConfigFile.read();
            config.putAll(this.serverProperties.getOverrides());
            StringBuilder propertySourceName = new StringBuilder().append("s3:").append(app);
            if (profile != null) {
                propertySourceName.append("-").append(profile);
            }
            PropertySource propertySource = new PropertySource(propertySourceName.toString(), (Map)config);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding property source to environment " + propertySource));
            }
            environment.add(propertySource);
        }
    }

    private String[] parseProfiles(String profiles) {
        return StringUtils.commaDelimitedListToStringArray((String)profiles);
    }

    private S3ConfigFile getS3ConfigFile(String application, String profile, String label) {
        String objectKeyPrefix = this.buildObjectKeyPrefix(application, profile, label);
        return this.getS3ConfigFile(objectKeyPrefix);
    }

    private String buildObjectKeyPrefix(String application, String profile, String label) {
        StringBuilder objectKeyPrefix = new StringBuilder();
        if (!ObjectUtils.isEmpty((Object)label)) {
            objectKeyPrefix.append(label).append(PATH_SEPARATOR);
        }
        objectKeyPrefix.append(application);
        if (!ObjectUtils.isEmpty((Object)profile)) {
            objectKeyPrefix.append("-").append(profile);
        }
        return objectKeyPrefix.toString();
    }

    private S3ConfigFile getS3ConfigFile(String keyPrefix) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting S3 config file for prefix " + keyPrefix));
        }
        try {
            ResponseInputStream<GetObjectResponse> responseInputStream = this.getObject(keyPrefix + ".properties");
            return new PropertyS3ConfigFile(((GetObjectResponse)responseInputStream.response()).versionId(), (InputStream)responseInputStream);
        }
        catch (Exception eProperties) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Did not find " + keyPrefix + ".properties.  Trying yml extension"), (Throwable)eProperties);
                }
                ResponseInputStream<GetObjectResponse> responseInputStream = this.getObject(keyPrefix + ".yml");
                return new YamlS3ConfigFile(((GetObjectResponse)responseInputStream.response()).versionId(), (InputStream)responseInputStream);
            }
            catch (Exception eYml) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Did not find " + keyPrefix + ".yml.  Trying yaml extension"), (Throwable)eYml);
                    }
                    ResponseInputStream<GetObjectResponse> responseInputStream = this.getObject(keyPrefix + ".yaml");
                    return new YamlS3ConfigFile(((GetObjectResponse)responseInputStream.response()).versionId(), (InputStream)responseInputStream);
                }
                catch (Exception eYaml) {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Did not find " + keyPrefix + ".yaml.  Trying json extension"), (Throwable)eYaml);
                        }
                        ResponseInputStream<GetObjectResponse> responseInputStream = this.getObject(keyPrefix + ".json");
                        return new JsonS3ConfigFile(((GetObjectResponse)responseInputStream.response()).versionId(), (InputStream)responseInputStream);
                    }
                    catch (Exception eJson) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Did not find S3 config file with properties, yml, yaml, or json extension for " + keyPrefix), (Throwable)eJson);
                        }
                        return null;
                    }
                }
            }
        }
    }

    private ResponseInputStream<GetObjectResponse> getObject(String key) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting object with key " + key));
        }
        return this.s3Client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucketName).key(key).build());
    }

    @Override
    public SearchPathLocator.Locations getLocations(String application, String profiles, String label) {
        StringBuilder baseLocation = new StringBuilder(AWS_S3_RESOURCE_SCHEME + this.bucketName + PATH_SEPARATOR);
        if (!StringUtils.hasText((String)label) && StringUtils.hasText((String)this.serverProperties.getDefaultLabel())) {
            label = this.serverProperties.getDefaultLabel();
        }
        if (StringUtils.hasText((String)label)) {
            baseLocation.append(label);
        }
        return new SearchPathLocator.Locations(application, profiles, label, null, new String[]{baseLocation.toString()});
    }
}

