/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.boot.bootstrap.BootstrapContext;
import org.springframework.boot.bootstrap.BootstrapRegistry;
import org.springframework.boot.bootstrap.BootstrapRegistryInitializer;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.config.client.ConfigServerConfigDataResource;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class ConfigServerBootstrapper
implements BootstrapRegistryInitializer {
    private Function<BootstrapContext, RestTemplate> restTemplateFactory;
    private LoaderInterceptor loaderInterceptor;

    static ConfigServerBootstrapper create() {
        return new ConfigServerBootstrapper();
    }

    public ConfigServerBootstrapper withRestTemplateFactory(Function<BootstrapContext, RestTemplate> restTemplateFactory) {
        this.restTemplateFactory = restTemplateFactory;
        return this;
    }

    public ConfigServerBootstrapper withLoaderInterceptor(LoaderInterceptor loaderInterceptor) {
        this.loaderInterceptor = loaderInterceptor;
        return this;
    }

    public void initialize(BootstrapRegistry registry) {
        if (this.restTemplateFactory != null) {
            registry.register(RestTemplate.class, this.restTemplateFactory::apply);
        }
        if (this.loaderInterceptor != null) {
            registry.register(LoaderInterceptor.class, BootstrapRegistry.InstanceSupplier.of((Object)this.loaderInterceptor));
        }
    }

    public static interface LoaderInterceptor
    extends Function<LoadContext, ConfigData> {
    }

    public static class LoadContext {
        private final ConfigDataLoaderContext loaderContext;
        private final ConfigServerConfigDataResource resource;
        private final Binder binder;
        private final LoaderInvocation invocation;

        LoadContext(ConfigDataLoaderContext loaderContext, ConfigServerConfigDataResource resource, Binder binder, LoaderInvocation invocation) {
            Assert.notNull((Object)loaderContext, (String)"loaderContext may not be null");
            Assert.notNull((Object)((Object)resource), (String)"resource may not be null");
            Assert.notNull((Object)binder, (String)"binder may not be null");
            Assert.notNull((Object)invocation, (String)"invocation may not be null");
            this.loaderContext = loaderContext;
            this.resource = resource;
            this.binder = binder;
            this.invocation = invocation;
        }

        public ConfigDataLoaderContext getLoaderContext() {
            return this.loaderContext;
        }

        public ConfigServerConfigDataResource getResource() {
            return this.resource;
        }

        public Binder getBinder() {
            return this.binder;
        }

        public LoaderInvocation getInvocation() {
            return this.invocation;
        }
    }

    @FunctionalInterface
    public static interface LoaderInvocation
    extends BiFunction<ConfigDataLoaderContext, ConfigServerConfigDataResource, ConfigData> {
    }
}

