/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple.reactive;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.boot.web.server.context.WebServerInitializedEvent;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.reactive.SimpleReactiveDiscoveryProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

public class SimpleReactiveDiscoveryClientConfigurations {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebServerInitializedEvent.class})
    static class WebApplicationSimpleReactiveDiscoveryClientConfiguration
    extends SimpleReactiveDiscoveryClientConfiguration
    implements ApplicationListener<WebServerInitializedEvent> {
        private final ObjectProvider<ServerProperties> serverProperties;
        private int port;

        WebApplicationSimpleReactiveDiscoveryClientConfiguration(InetUtils inet, ObjectProvider<ServerProperties> serverProperties) {
            super(inet);
            this.serverProperties = serverProperties;
        }

        public void onApplicationEvent(WebServerInitializedEvent webServerInitializedEvent) {
            this.port = webServerInitializedEvent.getWebServer().getPort();
            if (this.port > 0) {
                this.simple.getLocal().setHost(this.inet.findFirstNonLoopbackHostInfo().getHostname());
                this.simple.getLocal().setPort(this.port);
            }
        }

        @Override
        protected int findPort() {
            if (this.port > 0) {
                return this.port;
            }
            ServerProperties server = (ServerProperties)this.serverProperties.getIfAvailable();
            if (server != null && server.getPort() != null && server.getPort() > 0) {
                return server.getPort();
            }
            return super.findPort();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.boot.web.server.context.WebServerInitializedEvent"})
    static class StandardSimpleReactiveDiscoveryClientConfiguration
    extends SimpleReactiveDiscoveryClientConfiguration {
        StandardSimpleReactiveDiscoveryClientConfiguration(InetUtils inet) {
            super(inet);
        }
    }

    static abstract class SimpleReactiveDiscoveryClientConfiguration {
        protected final SimpleReactiveDiscoveryProperties simple = new SimpleReactiveDiscoveryProperties();
        protected final InetUtils inet;

        SimpleReactiveDiscoveryClientConfiguration(InetUtils inet) {
            this.inet = inet;
        }

        @Bean
        @Order
        public SimpleReactiveDiscoveryClient simpleReactiveDiscoveryClient(SimpleReactiveDiscoveryProperties properties) {
            return new SimpleReactiveDiscoveryClient(properties);
        }

        @Bean
        @ConditionalOnMissingBean
        public SimpleReactiveDiscoveryProperties simpleReactiveDiscoveryProperties(@Value(value="${spring.application.name:application}") String serviceId) {
            this.simple.getLocal().setServiceId(serviceId);
            this.simple.getLocal().setHost(this.inet.findFirstNonLoopbackHostInfo().getHostname());
            this.simple.getLocal().setPort(this.findPort());
            return this.simple;
        }

        protected int findPort() {
            return 8080;
        }
    }
}

