/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.circuitbreaker.httpservice;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.cloud.client.circuitbreaker.CircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.httpservice.CircuitBreakerAdapterDecorator;
import org.springframework.cloud.client.circuitbreaker.httpservice.CircuitBreakerConfigurerUtils;
import org.springframework.cloud.client.circuitbreaker.httpservice.CircuitBreakerRequestValueProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.support.RestClientHttpServiceGroupConfigurer;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.registry.HttpServiceGroupConfigurer;

public class CircuitBreakerRestClientHttpServiceGroupConfigurer
implements RestClientHttpServiceGroupConfigurer,
ApplicationContextAware {
    private static final int ORDER = 15;
    private final CircuitBreakerFactory<?, ?> circuitBreakerFactory;
    private ApplicationContext applicationContext;

    public CircuitBreakerRestClientHttpServiceGroupConfigurer(CircuitBreakerFactory<?, ?> circuitBreakerFactory) {
        this.circuitBreakerFactory = circuitBreakerFactory;
    }

    public void configureGroups(HttpServiceGroupConfigurer.Groups<RestClient.Builder> groups) {
        groups.forEachGroup((group, clientBuilder, factoryBuilder) -> {
            String groupName = group.name();
            Map<String, Class<?>> perGroupFallbackClasses = CircuitBreakerConfigurerUtils.resolveAnnotatedFallbackClasses(this.applicationContext, groupName);
            Map<String, Class<?>> fallbackClasses = !perGroupFallbackClasses.isEmpty() ? perGroupFallbackClasses : CircuitBreakerConfigurerUtils.resolveAnnotatedFallbackClasses(this.applicationContext, null);
            factoryBuilder.httpRequestValuesProcessor((HttpRequestValues.Processor)new CircuitBreakerRequestValueProcessor());
            factoryBuilder.exchangeAdapterDecorator(httpExchangeAdapter -> new CircuitBreakerAdapterDecorator((HttpExchangeAdapter)httpExchangeAdapter, this.buildCircuitBreaker(groupName), fallbackClasses));
        });
    }

    private CircuitBreaker buildCircuitBreaker(String groupName) {
        return this.circuitBreakerFactory.create(groupName);
    }

    public int getOrder() {
        return 15;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

