/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public final class MappingJwtGrantedAuthoritiesConverter
implements Converter<Jwt, Collection<GrantedAuthority>> {
    private static final Logger log = LoggerFactory.getLogger(MappingJwtGrantedAuthoritiesConverter.class);
    private static final String DEFAULT_AUTHORITY_PREFIX = "SCOPE_";
    private static final Collection<String> WELL_KNOWN_SCOPES_CLAIM_NAMES = Arrays.asList("scope", "scp");
    private static final Collection<String> WELL_KNOWN_GROUPS_CLAIM_NAMES = Arrays.asList("groups", "roles");
    private String authorityPrefix = "SCOPE_";
    private String authoritiesClaimName;
    private String groupAuthoritiesClaimName;
    private Map<String, String> roleAuthoritiesMapping = new HashMap<String, String>();
    private Map<String, String> groupAuthoritiesMapping = new HashMap<String, String>();

    public Collection<GrantedAuthority> convert(Jwt jwt) {
        log.debug("JWT: {}", (Object)jwt.getTokenValue());
        Set<GrantedAuthority> collect = this.getAuthorities(jwt).stream().flatMap(authority -> {
            if (this.roleAuthoritiesMapping.isEmpty() && this.groupAuthoritiesMapping.isEmpty()) {
                return Stream.of(authority);
            }
            Stream<String> s1 = this.roleAuthoritiesMapping.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(authority)).map(entry -> (String)entry.getKey()).distinct();
            Stream<String> s2 = this.groupAuthoritiesMapping.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(authority)).map(entry -> (String)entry.getKey()).distinct();
            return Stream.concat(s1, s2);
        }).distinct().map(authority -> new SimpleGrantedAuthority(this.authorityPrefix + authority)).collect(Collectors.toSet());
        log.debug("JWT granted: {}", collect);
        return collect;
    }

    public void setAuthorityPrefix(String authorityPrefix) {
        Assert.notNull((Object)authorityPrefix, (String)"authorityPrefix cannot be null");
        this.authorityPrefix = authorityPrefix;
    }

    public void setAuthoritiesClaimName(String authoritiesClaimName) {
        Assert.hasText((String)authoritiesClaimName, (String)"authoritiesClaimName cannot be empty");
        this.authoritiesClaimName = authoritiesClaimName;
    }

    public void setAuthoritiesMapping(Map<String, String> authoritiesMapping) {
        Assert.notNull(authoritiesMapping, (String)"authoritiesMapping cannot be null");
        this.roleAuthoritiesMapping = authoritiesMapping;
    }

    public void setGroupAuthoritiesClaimName(String groupAuthoritiesClaimName) {
        this.groupAuthoritiesClaimName = groupAuthoritiesClaimName;
    }

    public void setGroupAuthoritiesMapping(Map<String, String> groupAuthoritiesMapping) {
        this.groupAuthoritiesMapping = groupAuthoritiesMapping;
    }

    private String getAuthoritiesClaimName(Jwt jwt) {
        if (this.authoritiesClaimName != null) {
            return this.authoritiesClaimName;
        }
        for (String claimName : WELL_KNOWN_SCOPES_CLAIM_NAMES) {
            if (!jwt.hasClaim(claimName)) continue;
            return claimName;
        }
        return null;
    }

    private String getGroupAuthoritiesClaimName(Jwt jwt) {
        if (this.groupAuthoritiesClaimName != null) {
            return this.groupAuthoritiesClaimName;
        }
        for (String claimName : WELL_KNOWN_GROUPS_CLAIM_NAMES) {
            if (!jwt.hasClaim(claimName)) continue;
            return claimName;
        }
        return null;
    }

    private Collection<String> getAuthorities(Jwt jwt) {
        String scopeClaimName = this.getAuthoritiesClaimName(jwt);
        String groupClaimName = this.getGroupAuthoritiesClaimName(jwt);
        List claimAsStringList1 = null;
        List claimAsStringList2 = null;
        if (scopeClaimName != null && !ObjectUtils.isArray((Object)jwt.getClaim(scopeClaimName))) {
            claimAsStringList1 = jwt.getClaimAsStringList(scopeClaimName);
        }
        if (groupClaimName != null && !ObjectUtils.isArray((Object)jwt.getClaim(groupClaimName))) {
            claimAsStringList2 = jwt.getClaimAsStringList(groupClaimName);
        }
        ArrayList<String> claimAsStringList = new ArrayList<String>();
        if (claimAsStringList1 != null) {
            List collect = claimAsStringList1.stream().flatMap(c -> Arrays.stream(c.split(" "))).filter(c -> StringUtils.hasText((String)c)).collect(Collectors.toList());
            claimAsStringList.addAll(collect);
        }
        if (claimAsStringList2 != null) {
            claimAsStringList.addAll(claimAsStringList2);
        }
        return claimAsStringList;
    }
}

