/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.common.security.support.AuthoritiesMapper;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.util.StringUtils;

public class CustomOAuth2OidcUserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private static final Logger log = LoggerFactory.getLogger(CustomOAuth2OidcUserService.class);
    final OidcUserService delegate = new OidcUserService();
    final AuthoritiesMapper authorityMapper;

    public CustomOAuth2OidcUserService(AuthoritiesMapper authorityMapper) {
        this.authorityMapper = authorityMapper;
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        log.debug("Load user");
        OidcUser oidcUser = this.delegate.loadUser(userRequest);
        OAuth2AccessToken accessToken = userRequest.getAccessToken();
        Set<GrantedAuthority> mappedAuthorities1 = this.authorityMapper.mapScopesToAuthorities(userRequest.getClientRegistration().getRegistrationId(), accessToken.getScopes(), accessToken.getTokenValue());
        ArrayList<String> roleClaims = oidcUser.getClaimAsStringList("groups");
        if (roleClaims == null) {
            roleClaims = oidcUser.getClaimAsStringList("roles");
        }
        if (roleClaims == null) {
            roleClaims = new ArrayList<String>();
        }
        log.debug("roleClaims: {}", roleClaims);
        Set<GrantedAuthority> mappedAuthorities2 = this.authorityMapper.mapClaimsToAuthorities(userRequest.getClientRegistration().getRegistrationId(), roleClaims);
        String userNameAttributeName = userRequest.getClientRegistration().getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
        log.debug("AccessToken: {}", (Object)accessToken.getTokenValue());
        HashSet<GrantedAuthority> mappedAuthorities = new HashSet<GrantedAuthority>(mappedAuthorities1);
        mappedAuthorities.addAll(mappedAuthorities2);
        DefaultOidcUser oidcUserToReturn = StringUtils.hasText((String)userNameAttributeName) ? new DefaultOidcUser(mappedAuthorities, userRequest.getIdToken(), oidcUser.getUserInfo(), userNameAttributeName) : new DefaultOidcUser(mappedAuthorities, userRequest.getIdToken(), oidcUser.getUserInfo());
        return oidcUserToReturn;
    }
}

