/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bootstrap;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.bootstrap.BootstrapContext;
import org.springframework.boot.bootstrap.BootstrapContextClosedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.Assert;

public interface BootstrapRegistry {
    public <T> void register(Class<T> var1, InstanceSupplier<T> var2);

    public <T> void registerIfAbsent(Class<T> var1, InstanceSupplier<T> var2);

    public <T> boolean isRegistered(Class<T> var1);

    public <T> @Nullable InstanceSupplier<T> getRegisteredInstanceSupplier(Class<T> var1);

    public void addCloseListener(ApplicationListener<BootstrapContextClosedEvent> var1);

    public static enum Scope {
        SINGLETON,
        PROTOTYPE;

    }

    @FunctionalInterface
    public static interface InstanceSupplier<T> {
        public @Nullable T get(BootstrapContext var1);

        default public Scope getScope() {
            return Scope.SINGLETON;
        }

        default public InstanceSupplier<T> withScope(final Scope scope) {
            Assert.notNull((Object)((Object)scope), (String)"'scope' must not be null");
            final InstanceSupplier parent = this;
            return new InstanceSupplier<T>(this){
                final /* synthetic */ InstanceSupplier this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public @Nullable T get(BootstrapContext context) {
                    return parent.get(context);
                }

                @Override
                public Scope getScope() {
                    return scope;
                }
            };
        }

        public static <T> InstanceSupplier<T> of(@Nullable T instance) {
            return registry -> instance;
        }

        public static <T> InstanceSupplier<T> from(@Nullable Supplier<T> supplier) {
            return registry -> supplier != null ? supplier.get() : null;
        }
    }
}

