/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.bind.AggregateBinder;
import org.springframework.boot.context.properties.bind.AggregateElementBinder;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.UnboundConfigurationPropertiesException;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.core.ResolvableType;

abstract class IndexedElementsBinder<T>
extends AggregateBinder<T> {
    private static final String[] INDEXES = new String[10];

    IndexedElementsBinder(Binder.Context context) {
        super(context);
    }

    @Override
    protected boolean isAllowRecursiveBinding(@Nullable ConfigurationPropertySource source) {
        return source == null || source instanceof IterableConfigurationPropertySource;
    }

    protected final void bindIndexed(ConfigurationPropertyName name, Bindable<?> target, AggregateElementBinder elementBinder, ResolvableType aggregateType, ResolvableType elementType, IndexedCollectionSupplier result) {
        for (ConfigurationPropertySource source : this.getContext().getSources()) {
            this.bindIndexed(source, name, target, elementBinder, result, aggregateType, elementType);
            if (!result.wasSupplied() || result.get() == null) continue;
            return;
        }
    }

    private void bindIndexed(ConfigurationPropertySource source, ConfigurationPropertyName root, Bindable<?> target, AggregateElementBinder elementBinder, IndexedCollectionSupplier collection, ResolvableType aggregateType, ResolvableType elementType) {
        ConfigurationProperty property = source.getConfigurationProperty(root);
        if (property != null) {
            this.getContext().setConfigurationProperty(property);
            this.bindValue(target, (Collection)collection.get(), aggregateType, elementType, property.getValue());
        } else {
            this.bindIndexed(source, root, elementBinder, collection, elementType);
        }
    }

    private void bindValue(Bindable<?> target, Collection<Object> collection, ResolvableType aggregateType, ResolvableType elementType, @Nullable Object value) {
        ResolvableType collectionType;
        CharSequence charSequence;
        if (value == null || value instanceof CharSequence && (charSequence = (CharSequence)value).isEmpty()) {
            return;
        }
        Object aggregate = this.convert(value, aggregateType, target.getAnnotations());
        Collection elements = (Collection)this.convert(aggregate, collectionType = ResolvableType.forClassWithGenerics(collection.getClass(), (ResolvableType[])new ResolvableType[]{elementType}), new Annotation[0]);
        if (elements != null) {
            collection.addAll(elements);
        }
    }

    private void bindIndexed(ConfigurationPropertySource source, ConfigurationPropertyName root, AggregateElementBinder elementBinder, IndexedCollectionSupplier collection, ResolvableType elementType) {
        ConfigurationPropertyName name;
        Object value;
        HashSet<String> knownIndexedChildren = new HashSet();
        if (source instanceof IterableConfigurationPropertySource) {
            IterableConfigurationPropertySource iterableSource = (IterableConfigurationPropertySource)source;
            knownIndexedChildren = this.getKnownIndexedChildren(iterableSource, root);
        }
        for (int i = 0; i < Integer.MAX_VALUE && (value = elementBinder.bind(name = this.appendIndex(root, i), Bindable.of(elementType), source)) != null; ++i) {
            knownIndexedChildren.remove(name.getLastElement(ConfigurationPropertyName.Form.UNIFORM));
            ((Collection)collection.get()).add(value);
        }
        if (source instanceof IterableConfigurationPropertySource) {
            IterableConfigurationPropertySource iterableSource = (IterableConfigurationPropertySource)source;
            this.assertNoUnboundChildren(knownIndexedChildren, iterableSource, root);
        }
    }

    private Set<String> getKnownIndexedChildren(IterableConfigurationPropertySource source, ConfigurationPropertyName root) {
        HashSet<String> knownIndexedChildren = new HashSet<String>();
        Iterator<ConfigurationPropertyName> iterator = source.filter(root::isAncestorOf).iterator();
        while (iterator.hasNext()) {
            ConfigurationPropertyName name = iterator.next();
            ConfigurationPropertyName choppedName = name.chop(root.getNumberOfElements() + 1);
            if (!choppedName.isLastElementIndexed()) continue;
            knownIndexedChildren.add(choppedName.getLastElement(ConfigurationPropertyName.Form.UNIFORM));
        }
        return knownIndexedChildren;
    }

    private void assertNoUnboundChildren(Set<String> unboundIndexedChildren, IterableConfigurationPropertySource source, ConfigurationPropertyName root) {
        if (unboundIndexedChildren.isEmpty()) {
            return;
        }
        TreeSet<ConfigurationProperty> unboundProperties = new TreeSet<ConfigurationProperty>();
        Iterator<ConfigurationPropertyName> iterator = source.filter(root::isAncestorOf).iterator();
        while (iterator.hasNext()) {
            ConfigurationPropertyName name = iterator.next();
            ConfigurationPropertyName choppedName = name.chop(root.getNumberOfElements() + 1);
            if (!choppedName.isLastElementIndexed() || !unboundIndexedChildren.contains(choppedName.getLastElement(ConfigurationPropertyName.Form.UNIFORM))) continue;
            unboundProperties.add(source.getConfigurationProperty(name));
        }
        if (!unboundProperties.isEmpty()) {
            throw new UnboundConfigurationPropertiesException(unboundProperties);
        }
    }

    private ConfigurationPropertyName appendIndex(ConfigurationPropertyName root, int i) {
        return root.append((String)(i < INDEXES.length ? INDEXES[i] : "[" + i + "]"));
    }

    private <C> @Nullable C convert(@Nullable Object value, ResolvableType type, Annotation ... annotations) {
        value = this.getContext().getPlaceholdersResolver().resolvePlaceholders(value);
        return (C)this.getContext().getConverter().convert(value, type, annotations);
    }

    static {
        for (int i = 0; i < INDEXES.length; ++i) {
            IndexedElementsBinder.INDEXES[i] = "[" + i + "]";
        }
    }

    protected static class IndexedCollectionSupplier
    extends AggregateBinder.AggregateSupplier<Collection<Object>> {
        public IndexedCollectionSupplier(Supplier<Collection<Object>> supplier) {
            super(supplier);
        }
    }
}

