/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationPropertiesCharSequenceToObjectConverter;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.FormattingConversionService;

class ConversionServiceDeducer {
    private final ApplicationContext applicationContext;

    ConversionServiceDeducer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Nullable List<ConversionService> getConversionServices() {
        if (this.hasUserDefinedConfigurationServiceBean()) {
            return Collections.singletonList((ConversionService)this.applicationContext.getBean("conversionService", ConversionService.class));
        }
        ApplicationContext applicationContext = this.applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
            return this.getConversionServices(configurableContext);
        }
        return null;
    }

    private List<ConversionService> getConversionServices(ConfigurableApplicationContext applicationContext) {
        ArrayList<ConversionService> conversionServices = new ArrayList<ConversionService>();
        FormattingConversionService beansConverterService = new FormattingConversionService();
        Map<String, Object> converterBeans = this.addBeans(applicationContext, beansConverterService);
        if (!converterBeans.isEmpty()) {
            conversionServices.add((ConversionService)beansConverterService);
        }
        if (applicationContext.getBeanFactory().getConversionService() != null) {
            conversionServices.add(applicationContext.getBeanFactory().getConversionService());
        }
        if (!converterBeans.isEmpty()) {
            conversionServices.add(ApplicationConversionService.getSharedInstance());
        }
        return conversionServices;
    }

    private Map<String, Object> addBeans(ConfigurableApplicationContext applicationContext, FormattingConversionService converterService) {
        DefaultConversionService.addCollectionConverters((ConverterRegistry)converterService);
        converterService.addConverter((GenericConverter)new ConfigurationPropertiesCharSequenceToObjectConverter((ConversionService)converterService));
        return ApplicationConversionService.addBeans((FormatterRegistry)converterService, (ListableBeanFactory)applicationContext.getBeanFactory(), "org.springframework.boot.context.properties.ConfigurationPropertiesBinding");
    }

    private boolean hasUserDefinedConfigurationServiceBean() {
        String beanName = "conversionService";
        return this.applicationContext.containsBean(beanName) && this.applicationContext.getAutowireCapableBeanFactory().isTypeMatch(beanName, ConversionService.class);
    }
}

