/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class ConfigDataLocation
implements OriginProvider {
    private static final ConfigDataLocation EMPTY = new ConfigDataLocation(false, "", null);
    public static final String OPTIONAL_PREFIX = "optional:";
    private final boolean optional;
    private final String value;
    private final @Nullable Origin origin;

    private ConfigDataLocation(boolean optional, String value, @Nullable Origin origin) {
        this.value = value;
        this.optional = optional;
        this.origin = origin;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasPrefix(String prefix) {
        return this.value.startsWith(prefix);
    }

    public String getNonPrefixedValue(String prefix) {
        return !this.hasPrefix(prefix) ? this.value : this.value.substring(prefix.length());
    }

    @Override
    public @Nullable Origin getOrigin() {
        return this.origin;
    }

    public ConfigDataLocation[] split() {
        return this.split(";");
    }

    public ConfigDataLocation[] split(String delimiter) {
        Assert.state((!this.value.isEmpty() ? 1 : 0) != 0, (String)"Unable to split empty locations");
        String[] values = StringUtils.delimitedListToStringArray((String)this.toString(), (String)delimiter);
        ConfigDataLocation[] result = new ConfigDataLocation[values.length];
        for (int i = 0; i < values.length; ++i) {
            int index = i;
            ConfigDataLocation configDataLocation = ConfigDataLocation.of(values[index]);
            result[i] = configDataLocation.withOrigin(this.getOrigin());
        }
        return result;
    }

    ConfigDataLocation withOrigin(@Nullable Origin origin) {
        return new ConfigDataLocation(this.optional, this.value, origin);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigDataLocation other = (ConfigDataLocation)obj;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return !this.optional ? this.value : OPTIONAL_PREFIX + this.value;
    }

    public static ConfigDataLocation of(@Nullable String location) {
        boolean optional = location != null && location.startsWith(OPTIONAL_PREFIX);
        String value = location != null && optional ? location.substring(OPTIONAL_PREFIX.length()) : location;
        return StringUtils.hasText((String)value) ? new ConfigDataLocation(optional, value, null) : EMPTY;
    }

    static boolean isNotEmpty(@Nullable ConfigDataLocation location) {
        return location != null && !location.getValue().isEmpty();
    }
}

