/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslManagerBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.StringUtils;

public interface SslBundle {
    public static final String DEFAULT_PROTOCOL = "TLS";

    public SslStoreBundle getStores();

    public SslBundleKey getKey();

    public SslOptions getOptions();

    public String getProtocol();

    public SslManagerBundle getManagers();

    default public SSLContext createSslContext() {
        return this.getManagers().createSslContext(this.getProtocol());
    }

    public static SslBundle of(SslStoreBundle stores) {
        return SslBundle.of(stores, null, null);
    }

    public static SslBundle of(SslStoreBundle stores, SslBundleKey key) {
        return SslBundle.of(stores, key, null);
    }

    public static SslBundle of(SslStoreBundle stores, SslBundleKey key, SslOptions options) {
        return SslBundle.of(stores, key, options, null);
    }

    public static SslBundle of(SslStoreBundle stores, SslBundleKey key, SslOptions options, String protocol) {
        return SslBundle.of(stores, key, options, protocol, null);
    }

    public static SslBundle of(final SslStoreBundle stores, final SslBundleKey key, final SslOptions options, final String protocol, SslManagerBundle managers) {
        final SslManagerBundle managersToUse = managers != null ? managers : SslManagerBundle.from(stores, key);
        return new SslBundle(){

            @Override
            public SslStoreBundle getStores() {
                return stores != null ? stores : SslStoreBundle.NONE;
            }

            @Override
            public SslBundleKey getKey() {
                return key != null ? key : SslBundleKey.NONE;
            }

            @Override
            public SslOptions getOptions() {
                return options != null ? options : SslOptions.NONE;
            }

            @Override
            public String getProtocol() {
                return !StringUtils.hasText((String)protocol) ? SslBundle.DEFAULT_PROTOCOL : protocol;
            }

            @Override
            public SslManagerBundle getManagers() {
                return managersToUse;
            }

            public String toString() {
                ToStringCreator creator = new ToStringCreator((Object)this);
                creator.append("key", (Object)this.getKey());
                creator.append("options", (Object)this.getOptions());
                creator.append("protocol", (Object)this.getProtocol());
                creator.append("stores", (Object)this.getStores());
                return creator.toString();
            }
        };
    }

    public static SslBundle systemDefault() {
        try {
            final KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(null, null);
            final TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            final SSLContext sslContext = SSLContext.getDefault();
            return SslBundle.of(null, null, null, null, new SslManagerBundle(){

                @Override
                public KeyManagerFactory getKeyManagerFactory() {
                    return keyManagerFactory;
                }

                @Override
                public TrustManagerFactory getTrustManagerFactory() {
                    return trustManagerFactory;
                }

                @Override
                public SSLContext createSslContext(String protocol) {
                    return sslContext;
                }
            });
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new IllegalStateException("Could not initialize system default SslBundle: " + ex.getMessage(), ex);
        }
    }
}

