/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.test.autoconfigure;

import org.htmlunit.WebClient;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.test.web.htmlunit.UriBuilderFactoryWebClient;
import org.springframework.boot.webmvc.test.autoconfigure.MockMvcAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.htmlunit.MockMvcWebClientBuilder;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;

@AutoConfiguration(after={MockMvcAutoConfiguration.class})
@ConditionalOnClass(value={WebClient.class})
@ConditionalOnBooleanProperty(name={"spring.test.mockmvc.htmlunit.webclient.enabled"}, matchIfMissing=true)
public final class MockMvcWebClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={WebClient.class, MockMvcWebClientBuilder.class})
    @ConditionalOnBean(value={MockMvc.class})
    MockMvcWebClientBuilder mockMvcWebClientBuilder(Environment environment, MockMvc mockMvc) {
        String url = environment.getProperty("spring.test.mockmvc.htmlunit.url", "http://localhost");
        return MockMvcWebClientBuilder.mockMvcSetup((MockMvc)mockMvc).withDelegate((WebClient)new UriBuilderFactoryWebClient((UriBuilderFactory)new DefaultUriBuilderFactory(url)));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={MockMvcWebClientBuilder.class})
    WebClient htmlUnitWebClient(MockMvcWebClientBuilder builder) {
        return builder.build();
    }
}

