/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.autoconfigure;

import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.webflux.autoconfigure.ResourceHandlerRegistrationCustomizer;
import org.springframework.util.Assert;
import org.springframework.web.reactive.config.ResourceChainRegistration;
import org.springframework.web.reactive.config.ResourceHandlerRegistration;
import org.springframework.web.reactive.resource.EncodedResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.VersionResourceResolver;

class ResourceChainResourceHandlerRegistrationCustomizer
implements ResourceHandlerRegistrationCustomizer {
    private final WebProperties.Resources resourceProperties;

    ResourceChainResourceHandlerRegistrationCustomizer(WebProperties.Resources resources) {
        this.resourceProperties = resources;
    }

    @Override
    public void customize(ResourceHandlerRegistration registration) {
        WebProperties.Resources.Chain properties = this.resourceProperties.getChain();
        this.configureResourceChain(properties, registration.resourceChain(properties.isCache()));
    }

    private void configureResourceChain(WebProperties.Resources.Chain properties, ResourceChainRegistration chain) {
        WebProperties.Resources.Chain.Strategy strategy = properties.getStrategy();
        if (properties.isCompressed()) {
            chain.addResolver((ResourceResolver)new EncodedResourceResolver());
        }
        if (strategy.getFixed().isEnabled() || strategy.getContent().isEnabled()) {
            chain.addResolver(this.getVersionResourceResolver(strategy));
        }
    }

    private ResourceResolver getVersionResourceResolver(WebProperties.Resources.Chain.Strategy properties) {
        VersionResourceResolver resolver = new VersionResourceResolver();
        if (properties.getFixed().isEnabled()) {
            String version = properties.getFixed().getVersion();
            String[] paths = properties.getFixed().getPaths();
            Assert.state((version != null ? 1 : 0) != 0, (String)"'version' must not be null");
            resolver.addFixedVersionStrategy(version, paths);
        }
        if (properties.getContent().isEnabled()) {
            String[] paths = properties.getContent().getPaths();
            resolver.addContentVersionStrategy(paths);
        }
        return resolver;
    }
}

