/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.actuate.exchanges;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.web.exchanges.RecordableHttpResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;

class RecordableServerHttpResponse
implements RecordableHttpResponse {
    private final int status;
    private final Map<String, List<String>> headers;

    RecordableServerHttpResponse(ServerHttpResponse response) {
        this.status = response.getStatusCode() != null ? response.getStatusCode().value() : HttpStatus.OK.value();
        LinkedHashMap headers = new LinkedHashMap();
        response.getHeaders().forEach(headers::put);
        this.headers = Collections.unmodifiableMap(headers);
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }
}

