/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.transaction.autoconfigure;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.boot.transaction.autoconfigure.TransactionManagerCustomizer;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;

@ConfigurationProperties(value="spring.transaction")
public class TransactionProperties
implements TransactionManagerCustomizer<AbstractPlatformTransactionManager> {
    @DurationUnit(value=ChronoUnit.SECONDS)
    private @Nullable Duration defaultTimeout;
    private @Nullable Boolean rollbackOnCommitFailure;

    public @Nullable Duration getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(@Nullable Duration defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public @Nullable Boolean getRollbackOnCommitFailure() {
        return this.rollbackOnCommitFailure;
    }

    public void setRollbackOnCommitFailure(@Nullable Boolean rollbackOnCommitFailure) {
        this.rollbackOnCommitFailure = rollbackOnCommitFailure;
    }

    @Override
    public void customize(AbstractPlatformTransactionManager transactionManager) {
        if (this.defaultTimeout != null) {
            transactionManager.setDefaultTimeout((int)this.defaultTimeout.getSeconds());
        }
        if (this.rollbackOnCommitFailure != null) {
            transactionManager.setRollbackOnCommitFailure(this.rollbackOnCommitFailure.booleanValue());
        }
    }
}

