/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.context;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.container.ContainerImageMetadata;
import org.springframework.boot.testcontainers.context.TestcontainerFieldBeanDefinition;
import org.springframework.core.AttributeAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.testcontainers.containers.Container;
import org.testcontainers.lifecycle.Startable;

class ContainerFieldsImporter {
    ContainerFieldsImporter() {
    }

    Set<Startable> registerBeanDefinitions(BeanDefinitionRegistry registry, Class<?> definitionClass) {
        HashSet<Startable> importedContainers = new HashSet<Startable>();
        for (Field field : this.getContainerFields(definitionClass)) {
            this.assertValid(field);
            Container<?> container = this.getContainer(field);
            if (container instanceof Startable) {
                Startable startable = (Startable)container;
                importedContainers.add(startable);
            }
            this.registerBeanDefinition(registry, field, container);
        }
        return importedContainers;
    }

    private List<Field> getContainerFields(Class<?> containersClass) {
        ArrayList containerFields = new ArrayList();
        ReflectionUtils.doWithFields(containersClass, containerFields::add, this::isContainerField);
        return List.copyOf(containerFields);
    }

    private boolean isContainerField(Field candidate) {
        return Container.class.isAssignableFrom(candidate.getType());
    }

    private void assertValid(Field field) {
        Assert.state((boolean)Modifier.isStatic(field.getModifiers()), () -> "Container field '" + field.getName() + "' must be static");
    }

    private Container<?> getContainer(Field field) {
        ReflectionUtils.makeAccessible((Field)field);
        Container container = (Container)ReflectionUtils.getField((Field)field, null);
        Assert.state((container != null ? 1 : 0) != 0, () -> "Container field '" + field.getName() + "' must not have a null value");
        return container;
    }

    private void registerBeanDefinition(BeanDefinitionRegistry registry, Field field, Container<?> container) {
        ContainerImageMetadata containerMetadata = new ContainerImageMetadata(container.getDockerImageName());
        TestcontainerFieldBeanDefinition beanDefinition = new TestcontainerFieldBeanDefinition(field, container);
        containerMetadata.addTo((AttributeAccessor)beanDefinition);
        String beanName = this.generateBeanName(field);
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    private String generateBeanName(Field field) {
        return "importTestContainer.%s.%s".formatted(field.getDeclaringClass().getName(), field.getName());
    }
}

