/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactories;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.testcontainers.beans.TestcontainerBeanDefinition;
import org.springframework.boot.testcontainers.service.connection.BeanOrigin;
import org.springframework.boot.testcontainers.service.connection.ConnectionDetailsRegistrar;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.springframework.boot.testcontainers.service.connection.ServiceConnection;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.type.AnnotationMetadata;
import org.testcontainers.containers.Container;

class ServiceConnectionAutoConfigurationRegistrar
implements ImportBeanDefinitionRegistrar {
    private final BeanFactory beanFactory;

    ServiceConnectionAutoConfigurationRegistrar(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory listableBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
            this.registerBeanDefinitions(listableBeanFactory, registry);
        }
    }

    private void registerBeanDefinitions(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry) {
        ConnectionDetailsRegistrar registrar = new ConnectionDetailsRegistrar((ListableBeanFactory)beanFactory, new ConnectionDetailsFactories());
        for (String beanName : beanFactory.getBeanNamesForType(Container.class)) {
            BeanDefinition beanDefinition = this.getBeanDefinition(beanFactory, beanName);
            for (ServiceConnection annotation : this.getAnnotations(beanFactory, beanName, beanDefinition)) {
                ContainerConnectionSource source = this.createSource(beanFactory, beanName, beanDefinition, annotation);
                registrar.registerBeanDefinitions(registry, source);
            }
        }
    }

    private Set<ServiceConnection> getAnnotations(ConfigurableListableBeanFactory beanFactory, String beanName, BeanDefinition beanDefinition) {
        LinkedHashSet<ServiceConnection> annotations = new LinkedHashSet<ServiceConnection>();
        annotations.addAll(beanFactory.findAllAnnotationsOnBean(beanName, ServiceConnection.class, false));
        if (beanDefinition instanceof TestcontainerBeanDefinition) {
            TestcontainerBeanDefinition testcontainerBeanDefinition = (TestcontainerBeanDefinition)beanDefinition;
            testcontainerBeanDefinition.getAnnotations().stream(ServiceConnection.class).map(MergedAnnotation::synthesize).forEach(annotations::add);
        }
        return annotations;
    }

    private BeanDefinition getBeanDefinition(ConfigurableListableBeanFactory beanFactory, String beanName) {
        try {
            return beanFactory.getBeanDefinition(beanName);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    private <C extends Container<?>> ContainerConnectionSource<C> createSource(ConfigurableListableBeanFactory beanFactory, String beanName, BeanDefinition beanDefinition, ServiceConnection annotation) {
        String string;
        BeanOrigin origin = new BeanOrigin(beanName, beanDefinition);
        Class containerType = beanFactory.getType(beanName, false);
        if (beanDefinition instanceof TestcontainerBeanDefinition) {
            TestcontainerBeanDefinition testcontainerBeanDefinition = (TestcontainerBeanDefinition)beanDefinition;
            string = testcontainerBeanDefinition.getContainerImageName();
        } else {
            string = null;
        }
        String containerImageName = string;
        return new ContainerConnectionSource<Container>(beanName, (Origin)origin, containerType, containerImageName, annotation, () -> (Container)beanFactory.getBean(beanName, containerType));
    }
}

