/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingException;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.test.json.AbstractJsonMarshalTester;
import org.springframework.boot.test.json.JsonContent;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.ObjectReader;
import tools.jackson.databind.ObjectWriter;
import tools.jackson.databind.json.JsonMapper;

public class JacksonTester<T>
extends AbstractJsonMarshalTester<T> {
    private final JsonMapper jsonMapper;
    private @Nullable Class<?> view;

    protected JacksonTester(JsonMapper jsonMapper) {
        Assert.notNull((Object)jsonMapper, (String)"'objectMapper' must not be null");
        this.jsonMapper = jsonMapper;
    }

    public JacksonTester(Class<?> resourceLoadClass, ResolvableType type, JsonMapper jsonMapper) {
        this(resourceLoadClass, type, jsonMapper, null);
    }

    public JacksonTester(Class<?> resourceLoadClass, ResolvableType type, JsonMapper jsonMapper, @Nullable Class<?> view) {
        super(resourceLoadClass, type);
        Assert.notNull((Object)jsonMapper, (String)"'jsonMapper' must not be null");
        this.jsonMapper = jsonMapper;
        this.view = view;
    }

    @Override
    protected JsonContent<T> getJsonContent(String json) {
        Configuration configuration = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider((ObjectMapper)this.jsonMapper)).mappingProvider((MappingProvider)new JacksonMappingProvider((ObjectMapper)this.jsonMapper)).build();
        Class<?> resourceLoadClass = this.getResourceLoadClass();
        Assert.state((resourceLoadClass != null ? 1 : 0) != 0, (String)"'resourceLoadClass' must not be null");
        return new JsonContent(resourceLoadClass, this.getType(), json, configuration);
    }

    @Override
    protected T readObject(InputStream inputStream, ResolvableType type) throws IOException {
        return (T)this.getObjectReader(type).readValue(inputStream);
    }

    @Override
    protected T readObject(Reader reader, ResolvableType type) throws IOException {
        return (T)this.getObjectReader(type).readValue(reader);
    }

    private ObjectReader getObjectReader(ResolvableType type) {
        ObjectReader objectReader = this.jsonMapper.readerFor(this.getType(type));
        if (this.view != null) {
            return objectReader.withView(this.view);
        }
        return objectReader;
    }

    @Override
    protected String writeObject(T value, ResolvableType type) throws IOException {
        return this.getObjectWriter(type).writeValueAsString(value);
    }

    private ObjectWriter getObjectWriter(ResolvableType type) {
        ObjectWriter objectWriter = this.jsonMapper.writerFor(this.getType(type));
        if (this.view != null) {
            return objectWriter.withView(this.view);
        }
        return objectWriter;
    }

    private JavaType getType(ResolvableType type) {
        return this.jsonMapper.constructType(type.getType());
    }

    public static void initFields(Object testInstance, JsonMapper jsonMapper) {
        new JacksonFieldInitializer().initFields(testInstance, jsonMapper);
    }

    public static void initFields(Object testInstance, ObjectFactory<JsonMapper> jsonMapperFactory) {
        new JacksonFieldInitializer().initFields(testInstance, jsonMapperFactory);
    }

    public JacksonTester<T> forView(Class<?> view) {
        Class<?> resourceLoadClass = this.getResourceLoadClass();
        ResolvableType type = this.getType();
        Assert.state((resourceLoadClass != null ? 1 : 0) != 0, (String)"'resourceLoadClass' must not be null");
        Assert.state((type != null ? 1 : 0) != 0, (String)"'type' must not be null");
        return new JacksonTester<T>(resourceLoadClass, type, this.jsonMapper, view);
    }

    private static final class JacksonJsonProvider
    extends AbstractJsonProvider {
        private final ObjectMapper objectMapper;
        private final ObjectReader objectReader;

        private JacksonJsonProvider(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            this.objectReader = objectMapper.reader().forType(Object.class);
        }

        public Object parse(String json) throws InvalidJsonException {
            try {
                return this.objectReader.readValue(json);
            }
            catch (JacksonException ex) {
                throw new InvalidJsonException((Throwable)ex, json);
            }
        }

        public Object parse(byte[] json) throws InvalidJsonException {
            try {
                return this.objectReader.readValue(json);
            }
            catch (JacksonException ex) {
                throw new InvalidJsonException((Throwable)ex, new String(json, StandardCharsets.UTF_8));
            }
        }

        public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
            try {
                return this.objectReader.readValue((Reader)new InputStreamReader(jsonStream, charset));
            }
            catch (UnsupportedEncodingException | JacksonException ex) {
                throw new InvalidJsonException(ex);
            }
        }

        public String toJson(Object obj) {
            StringWriter writer = new StringWriter();
            try (JsonGenerator generator = this.objectMapper.createGenerator((Writer)writer);){
                this.objectMapper.writeValue(generator, obj);
            }
            catch (JacksonException ex) {
                throw new InvalidJsonException((Throwable)ex);
            }
            return writer.toString();
        }

        public List<Object> createArray() {
            return new LinkedList<Object>();
        }

        public Object createMap() {
            return new LinkedHashMap();
        }
    }

    private static final class JacksonMappingProvider
    implements MappingProvider {
        private final ObjectMapper objectMapper;

        private JacksonMappingProvider(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public <T> @Nullable T map(Object source, Class<T> targetType, Configuration configuration) {
            if (source == null) {
                return null;
            }
            try {
                return (T)this.objectMapper.convertValue(source, targetType);
            }
            catch (Exception ex) {
                throw new MappingException((Throwable)ex);
            }
        }

        public <T> @Nullable T map(Object source, TypeRef<T> targetType, Configuration configuration) {
            if (source == null) {
                return null;
            }
            JavaType type = this.objectMapper.getTypeFactory().constructType(targetType.getType());
            try {
                return (T)this.objectMapper.convertValue(source, type);
            }
            catch (Exception ex) {
                throw new MappingException((Throwable)ex);
            }
        }
    }

    private static class JacksonFieldInitializer
    extends AbstractJsonMarshalTester.FieldInitializer<JsonMapper> {
        protected JacksonFieldInitializer() {
            super(JacksonTester.class);
        }

        @Override
        protected AbstractJsonMarshalTester<Object> createTester(Class<?> resourceLoadClass, ResolvableType type, JsonMapper marshaller) {
            return new JacksonTester<Object>(resourceLoadClass, type, marshaller);
        }
    }
}

