/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.json;

import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.test.json.AbstractJsonMarshalTester;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class JsonMarshalTesterRuntimeHints
implements RuntimeHintsRegistrar {
    private final Class<? extends AbstractJsonMarshalTester> tester;

    protected JsonMarshalTesterRuntimeHints(Class<? extends AbstractJsonMarshalTester> tester) {
        this.tester = tester;
    }

    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        ReflectionHints reflection = hints.reflection();
        reflection.registerType(this.tester, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
        Method method = ReflectionUtils.findMethod(this.tester, (String)"initialize", (Class[])new Class[]{Class.class, ResolvableType.class});
        Assert.state((method != null ? 1 : 0) != 0, (String)"'method' must not be null");
        reflection.registerMethod(method, ExecutableMode.INVOKE);
    }
}

