/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.servlet;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConverters;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.assertj.MockMvcTester;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"org.assertj.core.api.Assert"})
class MockMvcTesterConfiguration {
    MockMvcTesterConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    MockMvcTester mockMvcTester(MockMvc mockMvc, ObjectProvider<HttpMessageConverters> httpMessageConverters) {
        MockMvcTester mockMvcTester = MockMvcTester.create((MockMvc)mockMvc);
        HttpMessageConverters converters = (HttpMessageConverters)httpMessageConverters.getIfAvailable();
        if (converters != null) {
            mockMvcTester = mockMvcTester.withHttpMessageConverters((Iterable)converters);
        }
        return mockMvcTester;
    }
}

