/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.actuate.observability;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.test.autoconfigure.actuate.observability.AutoConfigureObservability;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;

class ObservabilityContextCustomizerFactory
implements ContextCustomizerFactory {
    static final String AUTO_CONFIGURE_PROPERTY = "spring.test.observability.auto-configure";

    ObservabilityContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        AutoConfigureObservability annotation = (AutoConfigureObservability)TestContextAnnotationUtils.findMergedAnnotation(testClass, AutoConfigureObservability.class);
        return new DisableObservabilityContextCustomizer(annotation);
    }

    private static class DisableObservabilityContextCustomizer
    implements ContextCustomizer {
        private final @Nullable AutoConfigureObservability annotation;

        DisableObservabilityContextCustomizer(@Nullable AutoConfigureObservability annotation) {
            this.annotation = annotation;
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedContextConfiguration) {
            if (this.areMetricsDisabled((Environment)context.getEnvironment())) {
                TestPropertyValues.of((String[])new String[]{"management.defaults.metrics.export.enabled=false", "management.simple.metrics.export.enabled=true"}).applyTo(context);
            }
            if (this.isTracingDisabled((Environment)context.getEnvironment())) {
                TestPropertyValues.of((String[])new String[]{"management.tracing.export.enabled=false"}).applyTo(context);
            }
        }

        private boolean areMetricsDisabled(Environment environment) {
            if (this.annotation != null) {
                return !this.annotation.metrics();
            }
            return (Boolean)environment.getProperty(ObservabilityContextCustomizerFactory.AUTO_CONFIGURE_PROPERTY, Boolean.class, (Object)false) == false;
        }

        private boolean isTracingDisabled(Environment environment) {
            if (this.annotation != null) {
                return !this.annotation.tracing();
            }
            return (Boolean)environment.getProperty(ObservabilityContextCustomizerFactory.AUTO_CONFIGURE_PROPERTY, Boolean.class, (Object)false) == false;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisableObservabilityContextCustomizer that = (DisableObservabilityContextCustomizer)o;
            return Objects.equals(this.annotation, that.annotation);
        }

        public int hashCode() {
            return Objects.hash(this.annotation);
        }
    }
}

