/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.servlet.autoconfigure;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.servlet.encoding")
public class ServletEncodingProperties {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private Charset charset = DEFAULT_CHARSET;
    private @Nullable Boolean force;
    private @Nullable Boolean forceRequest;
    private @Nullable Boolean forceResponse;

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public boolean isForce() {
        return Boolean.TRUE.equals(this.force);
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isForceRequest() {
        return Boolean.TRUE.equals(this.forceRequest);
    }

    public void setForceRequest(boolean forceRequest) {
        this.forceRequest = forceRequest;
    }

    public boolean isForceResponse() {
        return Boolean.TRUE.equals(this.forceResponse);
    }

    public void setForceResponse(boolean forceResponse) {
        this.forceResponse = forceResponse;
    }

    public boolean shouldForce(HttpMessageType type) {
        Boolean force;
        Boolean bl = force = type != HttpMessageType.REQUEST ? this.forceResponse : this.forceRequest;
        if (force == null) {
            force = this.force;
        }
        if (force == null) {
            force = type == HttpMessageType.REQUEST;
        }
        return force;
    }

    public static enum HttpMessageType {
        REQUEST,
        RESPONSE;

    }
}

