/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.autoconfigure.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.h2console.autoconfigure.H2ConsoleProperties;
import org.springframework.boot.security.autoconfigure.servlet.StaticResourceRequest;
import org.springframework.boot.security.servlet.ApplicationContextRequestMatcher;
import org.springframework.boot.web.server.context.WebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public final class PathRequest {
    private PathRequest() {
    }

    public static StaticResourceRequest toStaticResources() {
        return StaticResourceRequest.INSTANCE;
    }

    public static H2ConsoleRequestMatcher toH2Console() {
        return new H2ConsoleRequestMatcher();
    }

    public static final class H2ConsoleRequestMatcher
    extends ApplicationContextRequestMatcher<ApplicationContext> {
        private volatile @Nullable RequestMatcher delegate;

        private H2ConsoleRequestMatcher() {
            super(ApplicationContext.class);
        }

        @Override
        protected boolean ignoreApplicationContext(WebApplicationContext applicationContext) {
            return WebServerApplicationContext.hasServerNamespace((ApplicationContext)applicationContext, (String)"management");
        }

        @Override
        protected void initialized(Supplier<ApplicationContext> context) {
            String path = ((H2ConsoleProperties)context.get().getBean(H2ConsoleProperties.class)).getPath();
            Assert.hasText((String)path, (String)"'path' in H2ConsoleProperties must not be empty");
            this.delegate = PathPatternRequestMatcher.withDefaults().matcher(path + "/**");
        }

        @Override
        protected boolean matches(HttpServletRequest request, Supplier<ApplicationContext> context) {
            RequestMatcher delegate = this.delegate;
            Assert.state((delegate != null ? 1 : 0) != 0, (String)"'delegate' must not be null");
            return delegate.matches(request);
        }
    }
}

