/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.autoconfigure;

import java.sql.SQLException;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetails;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetailsBeanPostProcessor;

class OracleUcpJdbcConnectionDetailsBeanPostProcessor
extends JdbcConnectionDetailsBeanPostProcessor<PoolDataSourceImpl> {
    OracleUcpJdbcConnectionDetailsBeanPostProcessor(ObjectProvider<JdbcConnectionDetails> connectionDetailsProvider) {
        super(PoolDataSourceImpl.class, connectionDetailsProvider);
    }

    @Override
    protected Object processDataSource(PoolDataSourceImpl dataSource, JdbcConnectionDetails connectionDetails) {
        try {
            dataSource.setURL(connectionDetails.getJdbcUrl());
            dataSource.setUser(connectionDetails.getUsername());
            dataSource.setPassword(connectionDetails.getPassword());
            dataSource.setConnectionFactoryClassName(connectionDetails.getDriverClassName());
            return dataSource;
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to set URL / user / password of datasource", ex);
        }
    }
}

