/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jackson.autoconfigure;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jackson.JsonComponentModule;
import org.springframework.boot.jackson.JsonMixinModule;
import org.springframework.boot.jackson.JsonMixinModuleEntries;
import org.springframework.boot.jackson.autoconfigure.JacksonProperties;
import org.springframework.boot.jackson.autoconfigure.JsonMapperBuilderCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.PropertyNamingStrategies;
import tools.jackson.databind.PropertyNamingStrategy;
import tools.jackson.databind.cfg.ConstructorDetector;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration
@ConditionalOnClass(value={JsonMapper.class})
public final class JacksonAutoConfiguration {
    @Bean
    JsonComponentModule jsonComponentModule() {
        return new JsonComponentModule();
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    JsonMapper.Builder jsonMapperBuilder(List<JsonMapperBuilderCustomizer> customizers) {
        JsonMapper.Builder builder = JsonMapper.builder();
        this.customize(builder, customizers);
        return builder;
    }

    private void customize(JsonMapper.Builder builder, List<JsonMapperBuilderCustomizer> customizers) {
        for (JsonMapperBuilderCustomizer customizer : customizers) {
            customizer.customize(builder);
        }
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={ObjectMapper.class})
    JsonMapper jacksonJsonMapper(JsonMapper.Builder builder) {
        return builder.build();
    }

    static class JacksonAutoConfigurationRuntimeHints
    implements RuntimeHintsRegistrar {
        JacksonAutoConfigurationRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            if (ClassUtils.isPresent((String)"tools.jackson.databind.PropertyNamingStrategy", (ClassLoader)classLoader)) {
                this.registerPropertyNamingStrategyHints(hints.reflection());
            }
        }

        private void registerPropertyNamingStrategyHints(ReflectionHints hints) {
            this.registerPropertyNamingStrategyHints(hints, PropertyNamingStrategies.class);
        }

        private void registerPropertyNamingStrategyHints(ReflectionHints hints, Class<?> type) {
            Stream.of(type.getDeclaredFields()).filter(this::isPropertyNamingStrategyField).forEach(arg_0 -> ((ReflectionHints)hints).registerField(arg_0));
        }

        private boolean isPropertyNamingStrategyField(Field candidate) {
            return ReflectionUtils.isPublicStaticFinal((Field)candidate) && candidate.getType().isAssignableFrom(PropertyNamingStrategy.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={JacksonProperties.class})
    static class JacksonJsonMapperBuilderCustomizerConfiguration {
        JacksonJsonMapperBuilderCustomizerConfiguration() {
        }

        @Bean
        StandardJsonMapperBuilderCustomizer standardJsonMapperBuilderCustomizer(JacksonProperties jacksonProperties, ObjectProvider<JacksonModule> modules) {
            return new StandardJsonMapperBuilderCustomizer(jacksonProperties, modules.stream().toList());
        }

        static final class StandardJsonMapperBuilderCustomizer
        implements JsonMapperBuilderCustomizer,
        Ordered {
            private final JacksonProperties jacksonProperties;
            private final Collection<JacksonModule> modules;

            StandardJsonMapperBuilderCustomizer(JacksonProperties jacksonProperties, Collection<JacksonModule> modules) {
                this.jacksonProperties = jacksonProperties;
                this.modules = modules;
            }

            public int getOrder() {
                return 0;
            }

            @Override
            public void customize(JsonMapper.Builder builder) {
                if (this.jacksonProperties.getDefaultPropertyInclusion() != null) {
                    builder.changeDefaultPropertyInclusion(handler -> handler.withValueInclusion(this.jacksonProperties.getDefaultPropertyInclusion()));
                }
                if (this.jacksonProperties.getTimeZone() != null) {
                    builder.defaultTimeZone(this.jacksonProperties.getTimeZone());
                }
                this.configureVisibility(builder, this.jacksonProperties.getVisibility());
                this.configureFeatures(builder, this.jacksonProperties.getDeserialization(), (arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
                this.configureFeatures(builder, this.jacksonProperties.getSerialization(), (arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
                this.configureFeatures(builder, this.jacksonProperties.getMapper(), (arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
                this.configureFeatures(builder, this.jacksonProperties.getRead(), (arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
                this.configureFeatures(builder, this.jacksonProperties.getWrite(), (arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
                this.configureFeatures(builder, this.jacksonProperties.getDatetime(), (arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
                this.configureFeatures(builder, this.jacksonProperties.getDatatype().getEnum(), (arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
                this.configureFeatures(builder, this.jacksonProperties.getDatatype().getJsonNode(), (arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
                this.configureDateFormat(builder);
                this.configurePropertyNamingStrategy(builder);
                this.configureModules(builder);
                this.configureLocale(builder);
                this.configureDefaultLeniency(builder);
                this.configureConstructorDetector(builder);
            }

            private <T> void configureFeatures(JsonMapper.Builder builder, Map<T, Boolean> features, BiConsumer<T, Boolean> configure) {
                features.forEach((feature, value) -> {
                    if (value != null) {
                        configure.accept((Object)feature, (Boolean)value);
                    }
                });
            }

            private void configureVisibility(JsonMapper.Builder builder, Map<PropertyAccessor, JsonAutoDetect.Visibility> visibilities) {
                builder.changeDefaultVisibility(visibilityChecker -> {
                    for (Map.Entry entry : visibilities.entrySet()) {
                        visibilityChecker = visibilityChecker.withVisibility((PropertyAccessor)entry.getKey(), (JsonAutoDetect.Visibility)entry.getValue());
                    }
                    return visibilityChecker;
                });
            }

            private void configureDateFormat(JsonMapper.Builder builder) {
                String dateFormat = this.jacksonProperties.getDateFormat();
                if (dateFormat != null) {
                    try {
                        Class dateFormatClass = ClassUtils.forName((String)dateFormat, null);
                        builder.defaultDateFormat((DateFormat)BeanUtils.instantiateClass((Class)dateFormatClass));
                    }
                    catch (ClassNotFoundException ex) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
                        TimeZone timeZone = this.jacksonProperties.getTimeZone();
                        if (timeZone == null) {
                            timeZone = new ObjectMapper().serializationConfig().getTimeZone();
                        }
                        simpleDateFormat.setTimeZone(timeZone);
                        builder.defaultDateFormat((DateFormat)simpleDateFormat);
                    }
                }
            }

            private void configurePropertyNamingStrategy(JsonMapper.Builder builder) {
                String strategy = this.jacksonProperties.getPropertyNamingStrategy();
                if (strategy != null) {
                    try {
                        this.configurePropertyNamingStrategyClass(builder, ClassUtils.forName((String)strategy, null));
                    }
                    catch (ClassNotFoundException ex) {
                        this.configurePropertyNamingStrategyField(builder, strategy);
                    }
                }
            }

            private void configurePropertyNamingStrategyClass(JsonMapper.Builder builder, Class<?> propertyNamingStrategyClass) {
                builder.propertyNamingStrategy((PropertyNamingStrategy)BeanUtils.instantiateClass(propertyNamingStrategyClass));
            }

            private void configurePropertyNamingStrategyField(JsonMapper.Builder builder, String fieldName) {
                Field field = this.findPropertyNamingStrategyField(fieldName);
                try {
                    builder.propertyNamingStrategy((PropertyNamingStrategy)field.get(null));
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }

            private Field findPropertyNamingStrategyField(String fieldName) {
                Field field = ReflectionUtils.findField(PropertyNamingStrategies.class, (String)fieldName, PropertyNamingStrategy.class);
                Assert.state((field != null ? 1 : 0) != 0, () -> "Constant named '" + fieldName + "' not found");
                return field;
            }

            private void configureModules(JsonMapper.Builder builder) {
                builder.addModules(this.modules);
            }

            private void configureLocale(JsonMapper.Builder builder) {
                Locale locale = this.jacksonProperties.getLocale();
                if (locale != null) {
                    builder.defaultLocale(locale);
                }
            }

            private void configureDefaultLeniency(JsonMapper.Builder builder) {
                Boolean defaultLeniency = this.jacksonProperties.getDefaultLeniency();
                if (defaultLeniency != null) {
                    builder.defaultLeniency(defaultLeniency);
                }
            }

            private void configureConstructorDetector(JsonMapper.Builder builder) {
                JacksonProperties.ConstructorDetectorStrategy strategy = this.jacksonProperties.getConstructorDetector();
                if (strategy != null) {
                    switch (strategy) {
                        case USE_PROPERTIES_BASED: {
                            builder.constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED);
                            break;
                        }
                        case USE_DELEGATING: {
                            builder.constructorDetector(ConstructorDetector.USE_DELEGATING);
                            break;
                        }
                        case EXPLICIT_ONLY: {
                            builder.constructorDetector(ConstructorDetector.EXPLICIT_ONLY);
                            break;
                        }
                        default: {
                            builder.constructorDetector(ConstructorDetector.DEFAULT);
                        }
                    }
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class JacksonMixinConfiguration {
        JacksonMixinConfiguration() {
        }

        @Bean
        static JsonMixinModuleEntries jsonMixinModuleEntries(ApplicationContext context) {
            List packages = AutoConfigurationPackages.has((BeanFactory)context) ? AutoConfigurationPackages.get((BeanFactory)context) : Collections.emptyList();
            return JsonMixinModuleEntries.scan(context, packages);
        }

        @Bean
        JsonMixinModule jsonMixinModule(ApplicationContext context, JsonMixinModuleEntries entries) {
            JsonMixinModule jsonMixinModule = new JsonMixinModule();
            jsonMixinModule.registerEntries(entries, context.getClassLoader());
            return jsonMixinModule;
        }
    }
}

