/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public final class DockerComposeFile {
    private static final List<String> SEARCH_ORDER = List.of("compose.yaml", "compose.yml", "docker-compose.yaml", "docker-compose.yml");
    private final List<File> files;

    private DockerComposeFile(List<File> files) {
        Assert.isTrue((!files.isEmpty() ? 1 : 0) != 0, (String)"'files' must not be empty");
        this.files = files.stream().map(DockerComposeFile::toCanonicalFile).toList();
    }

    private static File toCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public List<File> getFiles() {
        return this.files;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DockerComposeFile other = (DockerComposeFile)obj;
        return this.files.equals(other.files);
    }

    public int hashCode() {
        return this.files.hashCode();
    }

    public String toString() {
        if (this.files.size() == 1) {
            return this.files.get(0).getPath();
        }
        return this.files.stream().map(File::toString).collect(Collectors.joining(", "));
    }

    public static @Nullable DockerComposeFile find(@Nullable File workingDirectory) {
        File base;
        File file = base = workingDirectory != null ? workingDirectory : new File(".");
        if (!base.exists()) {
            return null;
        }
        Assert.state((boolean)base.isDirectory(), () -> "'%s' is not a directory".formatted(base));
        Path basePath = base.toPath();
        for (String candidate : SEARCH_ORDER) {
            Path resolved = basePath.resolve(candidate);
            if (!Files.exists(resolved, new LinkOption[0])) continue;
            return DockerComposeFile.of(resolved.toAbsolutePath().toFile());
        }
        return null;
    }

    public static DockerComposeFile of(File file) {
        Assert.notNull((Object)file, (String)"'file' must not be null");
        Assert.isTrue((boolean)file.exists(), () -> "'file' [%s] must exist".formatted(file));
        Assert.isTrue((boolean)file.isFile(), () -> "'file' [%s] must be a normal file".formatted(file));
        return new DockerComposeFile(Collections.singletonList(file));
    }

    public static DockerComposeFile of(Collection<? extends File> files) {
        Assert.notNull(files, (String)"'files' must not be null");
        for (File file : files) {
            Assert.notNull((Object)file, (String)"'files' must not contain null elements");
            Assert.isTrue((boolean)file.exists(), () -> "'files' content [%s] must exist".formatted(file));
            Assert.isTrue((boolean)file.isFile(), () -> "'files' content [%s] must be a normal file".formatted(file));
        }
        return new DockerComposeFile(List.copyOf(files));
    }
}

