/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.docker.compose.core.DockerCliCommand;
import org.springframework.boot.docker.compose.core.DockerCliComposeVersionResponse;
import org.springframework.boot.docker.compose.core.DockerComposeFile;
import org.springframework.boot.docker.compose.core.DockerJson;
import org.springframework.boot.docker.compose.core.DockerNotRunningException;
import org.springframework.boot.docker.compose.core.DockerProcessStartException;
import org.springframework.boot.docker.compose.core.ProcessExitException;
import org.springframework.boot.docker.compose.core.ProcessRunner;
import org.springframework.boot.docker.compose.core.ProcessStartException;
import org.springframework.boot.logging.LogLevel;
import org.springframework.core.log.LogMessage;
import org.springframework.util.CollectionUtils;

class DockerCli {
    private static final Map<@Nullable File, DockerCommands> dockerCommandsCache = new HashMap<File, DockerCommands>();
    private static final Log logger = LogFactory.getLog(DockerCli.class);
    private final ProcessRunner processRunner;
    private final DockerCommands dockerCommands;
    private final DockerComposeOptions dockerComposeOptions;
    private final DockerCliCommand.ComposeVersion composeVersion;

    DockerCli(@Nullable File workingDirectory, @Nullable DockerComposeOptions dockerComposeOptions) {
        this.processRunner = new ProcessRunner(workingDirectory);
        this.dockerCommands = dockerCommandsCache.computeIfAbsent(workingDirectory, key -> new DockerCommands(this.processRunner));
        this.dockerComposeOptions = dockerComposeOptions != null ? dockerComposeOptions : DockerComposeOptions.none();
        this.composeVersion = DockerCliCommand.ComposeVersion.of(this.dockerCommands.get(DockerCliCommand.Type.DOCKER_COMPOSE).version());
    }

    <R> R run(DockerCliCommand<R> dockerCommand) {
        List<String> command = this.createCommand(dockerCommand.getType());
        command.addAll(dockerCommand.getCommand(this.composeVersion));
        Consumer<String> outputConsumer = this.createOutputConsumer(dockerCommand.getLogLevel());
        String json = this.processRunner.run(outputConsumer, command.toArray(new String[0]));
        return dockerCommand.deserialize(json);
    }

    private @Nullable Consumer<String> createOutputConsumer(@Nullable LogLevel logLevel) {
        if (logLevel == null || logLevel == LogLevel.OFF) {
            return null;
        }
        return line -> logLevel.log(logger, line);
    }

    private List<String> createCommand(DockerCliCommand.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case DockerCliCommand.Type.DOCKER -> new ArrayList<String>(this.dockerCommands.get(type).command());
            case DockerCliCommand.Type.DOCKER_COMPOSE -> {
                List<String> var5_8;
                ArrayList<String> result = new ArrayList<String>(this.dockerCommands.get(type).command());
                DockerComposeFile composeFile = this.dockerComposeOptions.composeFile();
                if (composeFile != null) {
                    for (File var5_5 : composeFile.getFiles()) {
                        result.add("--file");
                        result.add(var5_5.getPath());
                    }
                }
                result.add("--ansi");
                result.add("never");
                Set<String> activeProfiles = this.dockerComposeOptions.activeProfiles();
                if (!CollectionUtils.isEmpty(activeProfiles)) {
                    for (String profile : activeProfiles) {
                        result.add("--profile");
                        result.add(profile);
                    }
                }
                if (!CollectionUtils.isEmpty(var5_8 = this.dockerComposeOptions.arguments())) {
                    result.addAll(var5_8);
                }
                yield result;
            }
        };
    }

    @Nullable DockerComposeFile getDockerComposeFile() {
        return this.dockerComposeOptions.composeFile();
    }

    private static class DockerCommands {
        private final DockerCommand dockerCommand;
        private final DockerCommand dockerComposeCommand;

        DockerCommands(ProcessRunner processRunner) {
            this.dockerCommand = this.getDockerCommand(processRunner);
            this.dockerComposeCommand = this.getDockerComposeCommand(processRunner);
        }

        private DockerCommand getDockerCommand(ProcessRunner processRunner) {
            try {
                String version = processRunner.run("docker", "version", "--format", "{{.Client.Version}}");
                logger.trace((Object)LogMessage.format((String)"Using docker %s", (Object)version));
                return new DockerCommand(version, List.of("docker"));
            }
            catch (ProcessStartException ex) {
                throw new DockerProcessStartException("Unable to start docker process. Is docker correctly installed?", ex);
            }
            catch (ProcessExitException ex) {
                if (ex.getStdErr().contains("docker daemon is not running") || ex.getStdErr().contains("Cannot connect to the Docker daemon")) {
                    throw new DockerNotRunningException(ex.getStdErr(), ex);
                }
                throw ex;
            }
        }

        private DockerCommand getDockerComposeCommand(ProcessRunner processRunner) {
            try {
                DockerCliComposeVersionResponse response = DockerJson.deserialize(processRunner.run("docker", "compose", "version", "--format", "json"), DockerCliComposeVersionResponse.class);
                logger.trace((Object)LogMessage.format((String)"Using Docker Compose %s", (Object)response.version()));
                return new DockerCommand(response.version(), List.of("docker", "compose"));
            }
            catch (ProcessExitException response) {
                try {
                    DockerCliComposeVersionResponse response2 = DockerJson.deserialize(processRunner.run("docker-compose", "version", "--format", "json"), DockerCliComposeVersionResponse.class);
                    logger.trace((Object)LogMessage.format((String)"Using docker-compose %s", (Object)response2.version()));
                    return new DockerCommand(response2.version(), List.of("docker-compose"));
                }
                catch (ProcessStartException ex) {
                    throw new DockerProcessStartException("Unable to start 'docker-compose' process or use 'docker compose'. Is docker correctly installed?", ex);
                }
            }
        }

        DockerCommand get(DockerCliCommand.Type type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case DockerCliCommand.Type.DOCKER -> this.dockerCommand;
                case DockerCliCommand.Type.DOCKER_COMPOSE -> this.dockerComposeCommand;
            };
        }
    }

    record DockerComposeOptions(@Nullable DockerComposeFile composeFile, Set<String> activeProfiles, List<String> arguments) {
        DockerComposeOptions(@Nullable DockerComposeFile composeFile, @Nullable Set<String> activeProfiles, @Nullable List<String> arguments) {
            this.composeFile = composeFile;
            this.activeProfiles = activeProfiles != null ? activeProfiles : Collections.emptySet();
            this.arguments = arguments != null ? arguments : Collections.emptyList();
        }

        static DockerComposeOptions none() {
            return new DockerComposeOptions(null, null, null);
        }
    }

    private record DockerCommand(String version, List<String> command) {
    }
}

