/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.ldap;

import java.util.Map;
import org.springframework.boot.autoconfigure.ldap.LdapConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class LLdapDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<LdapConnectionDetails> {
    LLdapDockerComposeConnectionDetailsFactory() {
        super("lldap/lldap", new String[0]);
    }

    @Override
    protected LdapConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new LLdapDockerComposeConnectionDetails(source.getRunningService());
    }

    static class LLdapDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements LdapConnectionDetails {
        private final String[] urls;
        private final String base;
        private final String username;
        private final String password;

        LLdapDockerComposeConnectionDetails(RunningService service) {
            super(service);
            Map<String, String> env = service.env();
            boolean usesTls = Boolean.parseBoolean(env.getOrDefault("LLDAP_LDAPS_OPTIONS__ENABLED", "false"));
            String ldapPort = usesTls ? env.getOrDefault("LLDAP_LDAPS_OPTIONS__PORT", "6360") : env.getOrDefault("LLDAP_LDAP_PORT", "3890");
            this.urls = new String[]{"%s://%s:%d".formatted(usesTls ? "ldaps" : "ldap", service.host(), service.ports().get(Integer.parseInt(ldapPort)))};
            this.base = env.getOrDefault("LLDAP_LDAP_BASE_DN", "dc=example,dc=com");
            this.password = env.getOrDefault("LLDAP_LDAP_USER_PASS", "password");
            this.username = "cn=admin,ou=people,%s".formatted(this.base);
        }

        public String[] getUrls() {
            return this.urls;
        }

        public String getBase() {
            return this.base;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

