/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.BiFunction;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.springframework.boot.configurationprocessor.TypeUtils;
import org.springframework.boot.configurationprocessor.metadata.ConfigurationMetadata;
import org.springframework.boot.configurationprocessor.metadata.InvalidConfigurationMetadataException;
import org.springframework.boot.configurationprocessor.metadata.JsonMarshaller;

class MetadataStore {
    static final String METADATA_PATH = "META-INF/spring-configuration-metadata.json";
    static final BiFunction<TypeElement, TypeUtils, String> SOURCE_METADATA_PATH = (type, typeUtils) -> "META-INF/spring/configuration-metadata/%s.json".formatted(typeUtils.getQualifiedName((Element)type));
    private static final String ADDITIONAL_METADATA_PATH = "META-INF/additional-spring-configuration-metadata.json";
    static final BiFunction<TypeElement, TypeUtils, String> ADDITIONAL_SOURCE_METADATA_PATH = (type, typeUtils) -> "META-INF/spring/configuration-metadata/additional/%s.json".formatted(typeUtils.getQualifiedName((Element)type));
    private static final String RESOURCES_DIRECTORY = "resources";
    private static final String CLASSES_DIRECTORY = "classes";
    private final ProcessingEnvironment environment;
    private final TypeUtils typeUtils;

    MetadataStore(ProcessingEnvironment environment, TypeUtils typeUtils) {
        this.environment = environment;
        this.typeUtils = typeUtils;
    }

    ConfigurationMetadata readMetadata() {
        return this.readMetadata(METADATA_PATH);
    }

    ConfigurationMetadata readMetadata(TypeElement typeElement) {
        return this.readMetadata(SOURCE_METADATA_PATH.apply(typeElement, this.typeUtils));
    }

    private ConfigurationMetadata readMetadata(String location) {
        try {
            return this.readMetadata(location, this.getMetadataResource(location).openInputStream());
        }
        catch (IOException ex) {
            return null;
        }
    }

    void writeMetadata(ConfigurationMetadata metadata) throws IOException {
        this.writeMetadata(metadata, () -> this.createMetadataResource(METADATA_PATH));
    }

    void writeMetadata(ConfigurationMetadata metadata, TypeElement typeElement) throws IOException {
        this.writeMetadata(metadata, () -> this.createMetadataResource(SOURCE_METADATA_PATH.apply(typeElement, this.typeUtils)));
    }

    private void writeMetadata(ConfigurationMetadata metadata, FileObjectSupplier fileObjectProvider) throws IOException {
        if (!metadata.getItems().isEmpty()) {
            try (OutputStream outputStream = fileObjectProvider.get().openOutputStream();){
                new JsonMarshaller().write(metadata, outputStream);
            }
        }
    }

    ConfigurationMetadata readAdditionalMetadata() {
        return this.readAdditionalMetadata(ADDITIONAL_METADATA_PATH);
    }

    ConfigurationMetadata readAdditionalMetadata(TypeElement typeElement) {
        return this.readAdditionalMetadata(ADDITIONAL_SOURCE_METADATA_PATH.apply(typeElement, this.typeUtils));
    }

    private ConfigurationMetadata readAdditionalMetadata(String location) {
        try {
            InputStream in = this.getAdditionalMetadataStream(location);
            return this.readMetadata(location, in);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private ConfigurationMetadata readMetadata(String location, InputStream in) {
        ConfigurationMetadata configurationMetadata;
        block9: {
            InputStream inputStream = in;
            try {
                configurationMetadata = new JsonMarshaller().read(in);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return null;
                }
                catch (Exception ex) {
                    throw new InvalidConfigurationMetadataException("Invalid additional meta-data in '" + location + "': " + ex.getMessage(), Diagnostic.Kind.ERROR);
                }
            }
            inputStream.close();
        }
        return configurationMetadata;
    }

    private FileObject getMetadataResource(String location) throws IOException {
        return this.environment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", location);
    }

    private FileObject createMetadataResource(String location) throws IOException {
        return this.environment.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", location, new Element[0]);
    }

    private InputStream getAdditionalMetadataStream(String additionalMetadataLocation) throws IOException {
        FileObject fileObject = this.environment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", additionalMetadataLocation);
        InputStream inputStream = this.getMetadataStream(fileObject);
        if (inputStream != null) {
            return inputStream;
        }
        try {
            File file = this.locateAdditionalMetadataFile(new File(fileObject.toUri()), additionalMetadataLocation);
            return file.exists() ? new FileInputStream(file) : fileObject.toUri().toURL().openStream();
        }
        catch (Exception ex) {
            throw new FileNotFoundException();
        }
    }

    private InputStream getMetadataStream(FileObject fileObject) {
        try {
            return fileObject.openInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    File locateAdditionalMetadataFile(File standardLocation, String additionalMetadataLocation) throws IOException {
        if (standardLocation.exists()) {
            return standardLocation;
        }
        String locations = this.environment.getOptions().get("org.springframework.boot.configurationprocessor.additionalMetadataLocations");
        if (locations != null) {
            for (String location : locations.split(",")) {
                File candidate = new File(location, additionalMetadataLocation);
                if (!candidate.isFile()) continue;
                return candidate;
            }
        }
        return new File(this.locateGradleResourcesDirectory(standardLocation), additionalMetadataLocation);
    }

    private File locateGradleResourcesDirectory(File standardAdditionalMetadataLocation) throws FileNotFoundException {
        String path = standardAdditionalMetadataLocation.getPath();
        int index = path.lastIndexOf(CLASSES_DIRECTORY);
        if (index < 0) {
            throw new FileNotFoundException();
        }
        String buildDirectoryPath = path.substring(0, index);
        File classOutputLocation = standardAdditionalMetadataLocation.getParentFile().getParentFile();
        return new File(buildDirectoryPath, "resources/" + classOutputLocation.getName());
    }

    private static interface FileObjectSupplier {
        public FileObject get() throws IOException;
    }
}

