/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.buildpack.platform.build.BuilderBuildpack;
import org.springframework.boot.buildpack.platform.build.Buildpack;
import org.springframework.boot.buildpack.platform.build.BuildpackReference;
import org.springframework.boot.buildpack.platform.build.BuildpackResolver;
import org.springframework.boot.buildpack.platform.build.BuildpackResolverContext;
import org.springframework.boot.buildpack.platform.build.Buildpacks;
import org.springframework.boot.buildpack.platform.build.DirectoryBuildpack;
import org.springframework.boot.buildpack.platform.build.ImageBuildpack;
import org.springframework.boot.buildpack.platform.build.TarGzipBuildpack;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

final class BuildpackResolvers {
    private static final List<BuildpackResolver> resolvers = BuildpackResolvers.getResolvers();

    private BuildpackResolvers() {
    }

    private static List<BuildpackResolver> getResolvers() {
        ArrayList<BuildpackResolver> resolvers = new ArrayList<BuildpackResolver>();
        resolvers.add(BuilderBuildpack::resolve);
        resolvers.add(DirectoryBuildpack::resolve);
        resolvers.add(TarGzipBuildpack::resolve);
        resolvers.add(ImageBuildpack::resolve);
        return Collections.unmodifiableList(resolvers);
    }

    static Buildpacks resolveAll(BuildpackResolverContext context, Collection<BuildpackReference> references) {
        Assert.notNull((Object)context, (String)"'context' must not be null");
        if (CollectionUtils.isEmpty(references)) {
            return Buildpacks.EMPTY;
        }
        ArrayList<Buildpack> buildpacks = new ArrayList<Buildpack>(references.size());
        for (BuildpackReference reference : references) {
            buildpacks.add(BuildpackResolvers.resolve(context, reference));
        }
        return Buildpacks.of(buildpacks);
    }

    private static Buildpack resolve(BuildpackResolverContext context, BuildpackReference reference) {
        Assert.notNull((Object)reference, (String)"'reference' must not be null");
        for (BuildpackResolver resolver : resolvers) {
            Buildpack buildpack = resolver.resolve(context, reference);
            if (buildpack == null) continue;
            return buildpack;
        }
        throw new IllegalArgumentException("Invalid buildpack reference '" + String.valueOf(reference) + "'");
    }
}

