/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.boot.buildpack.platform.docker.type.VolumeName;
import org.springframework.util.Assert;

public final class Binding {
    private static final Set<String> SENSITIVE_CONTAINER_PATHS = Set.of("/cnb", "/layers", "/workspace", "c:\\cnb", "c:\\layers", "c:\\workspace");
    private final String value;

    private Binding(String value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Binding)) {
            return false;
        }
        Binding binding = (Binding)obj;
        return Objects.equals(this.value, binding.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }

    public boolean usesSensitiveContainerPath() {
        return SENSITIVE_CONTAINER_PATHS.contains(this.getContainerDestinationPath());
    }

    String getContainerDestinationPath() {
        List<String> parts = this.getParts();
        Assert.state((parts.size() >= 2 ? 1 : 0) != 0, () -> "Expected 2 or more parts, but found %d".formatted(parts.size()));
        return parts.get(1);
    }

    private List<String> getParts() {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.value.length(); ++i) {
            char nextChar;
            char ch = this.value.charAt(i);
            char c = nextChar = i + 1 < this.value.length() ? this.value.charAt(i + 1) : (char)'\u0000';
            if (ch == ':' && nextChar != '\\') {
                parts.add(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            buffer.append(ch);
        }
        parts.add(buffer.toString());
        return parts;
    }

    public static Binding of(String value) {
        Assert.notNull((Object)value, (String)"'value' must not be null");
        return new Binding(value);
    }

    public static Binding from(VolumeName sourceVolume, String destination) {
        Assert.notNull((Object)sourceVolume, (String)"'sourceVolume' must not be null");
        return Binding.from(sourceVolume.toString(), destination);
    }

    public static Binding from(String source, String destination) {
        Assert.notNull((Object)source, (String)"'source' must not be null");
        Assert.notNull((Object)destination, (String)"'destination' must not be null");
        return new Binding(source + ":" + destination);
    }
}

