/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageConfig;
import org.springframework.boot.buildpack.platform.json.MappedObject;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import tools.jackson.databind.JsonNode;

final class BuildpackLayersMetadata
extends MappedObject {
    private static final String LABEL_NAME = "io.buildpacks.buildpack.layers";
    private final Buildpacks buildpacks = Buildpacks.fromJson(this.getNode());

    private BuildpackLayersMetadata(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    @Nullable BuildpackLayerDetails getBuildpack(String id, @Nullable String version) {
        return this.buildpacks.getBuildpack(id, version);
    }

    static BuildpackLayersMetadata fromImage(Image image) throws IOException {
        Assert.notNull((Object)image, (String)"'image' must not be null");
        return BuildpackLayersMetadata.fromImageConfig(image.getConfig());
    }

    static BuildpackLayersMetadata fromImageConfig(ImageConfig imageConfig) throws IOException {
        Assert.notNull((Object)imageConfig, (String)"'imageConfig' must not be null");
        String json = imageConfig.getLabels().get(LABEL_NAME);
        Assert.state((json != null ? 1 : 0) != 0, () -> "No 'io.buildpacks.buildpack.layers' label found in image config labels '" + StringUtils.collectionToCommaDelimitedString(imageConfig.getLabels().keySet()) + "'");
        return BuildpackLayersMetadata.fromJson(json);
    }

    static BuildpackLayersMetadata fromJson(String json) throws IOException {
        return BuildpackLayersMetadata.fromJson(SharedObjectMapper.get().readTree(json));
    }

    static BuildpackLayersMetadata fromJson(JsonNode node) {
        return new BuildpackLayersMetadata(node);
    }

    private static final class Buildpacks {
        private final Map<String, BuildpackVersions> buildpacks = new HashMap<String, BuildpackVersions>();

        private Buildpacks() {
        }

        private @Nullable BuildpackLayerDetails getBuildpack(String id, @Nullable String version) {
            if (this.buildpacks.containsKey(id)) {
                return this.buildpacks.get(id).getBuildpack(version);
            }
            return null;
        }

        private void addBuildpackVersions(String id, BuildpackVersions versions) {
            this.buildpacks.put(id, versions);
        }

        private static Buildpacks fromJson(JsonNode node) {
            Buildpacks buildpacks = new Buildpacks();
            node.properties().forEach(field -> buildpacks.addBuildpackVersions((String)field.getKey(), BuildpackVersions.fromJson((JsonNode)field.getValue())));
            return buildpacks;
        }
    }

    static final class BuildpackLayerDetails
    extends MappedObject {
        private final @Nullable String name = this.valueAt("/name", String.class);
        private final @Nullable String homepage = this.valueAt("/homepage", String.class);
        private final @Nullable String layerDiffId = this.valueAt("/layerDiffID", String.class);

        private BuildpackLayerDetails(JsonNode node) {
            super(node, MethodHandles.lookup());
        }

        @Nullable String getName() {
            return this.name;
        }

        @Nullable String getHomepage() {
            return this.homepage;
        }

        @Nullable String getLayerDiffId() {
            return this.layerDiffId;
        }

        private static BuildpackLayerDetails fromJson(JsonNode node) {
            return new BuildpackLayerDetails(node);
        }
    }

    private static final class BuildpackVersions {
        private final Map<String, BuildpackLayerDetails> versions = new HashMap<String, BuildpackLayerDetails>();

        private BuildpackVersions() {
        }

        private @Nullable BuildpackLayerDetails getBuildpack(@Nullable String version) {
            return this.versions.get(version);
        }

        private void addBuildpackVersion(String version, BuildpackLayerDetails details) {
            this.versions.put(version, details);
        }

        private static BuildpackVersions fromJson(JsonNode node) {
            BuildpackVersions versions = new BuildpackVersions();
            node.properties().forEach(field -> versions.addBuildpackVersion((String)field.getKey(), BuildpackLayerDetails.fromJson((JsonNode)field.getValue())));
            return versions;
        }
    }
}

