/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.springframework.boot.buildpack.platform.docker.UpdateEvent;

public abstract class ProgressUpdateEvent
extends UpdateEvent {
    private final String status;
    private final ProgressDetail progressDetail;
    private final String progress;

    protected ProgressUpdateEvent(String status, ProgressDetail progressDetail, String progress) {
        this.status = status;
        this.progressDetail = ProgressDetail.isEmpty(progressDetail) ? null : progressDetail;
        this.progress = progress;
    }

    public String getStatus() {
        return this.status;
    }

    public ProgressDetail getProgressDetail() {
        return this.progressDetail;
    }

    public String getProgress() {
        return this.progress;
    }

    public static class ProgressDetail {
        private final Long current;
        private final Long total;

        @JsonCreator
        public ProgressDetail(Long current, Long total) {
            this.current = current;
            this.total = total;
        }

        public int asPercentage() {
            int percentage = (int)(100.0 / (double)this.total.longValue() * (double)this.current.longValue());
            return percentage < 0 ? 0 : Math.min(percentage, 100);
        }

        private static boolean isEmpty(ProgressDetail progressDetail) {
            return progressDetail == null || progressDetail.current == null || progressDetail.total == null;
        }
    }
}

