/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.Assert;

public interface ContainerContent {
    public TarArchive getArchive();

    public String getDestinationPath();

    public static ContainerContent of(TarArchive archive) {
        return ContainerContent.of(archive, "/");
    }

    public static ContainerContent of(final TarArchive archive, final String destinationPath) {
        Assert.notNull((Object)archive, (String)"'archive' must not be null");
        Assert.hasText((String)destinationPath, (String)"'destinationPath' must not be empty");
        return new ContainerContent(){

            @Override
            public TarArchive getArchive() {
                return archive;
            }

            @Override
            public String getDestinationPath() {
                return destinationPath;
            }
        };
    }
}

