/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.build;

import java.io.IOException;
import java.util.Map;
import org.springframework.boot.buildpack.platform.build.BuildOwner;
import org.springframework.boot.buildpack.platform.build.BuilderMetadata;
import org.springframework.boot.buildpack.platform.build.Buildpacks;
import org.springframework.boot.buildpack.platform.build.Creator;
import org.springframework.boot.buildpack.platform.docker.type.Image;
import org.springframework.boot.buildpack.platform.docker.type.ImageArchive;
import org.springframework.boot.buildpack.platform.docker.type.ImageReference;
import org.springframework.boot.buildpack.platform.docker.type.Layer;
import org.springframework.boot.buildpack.platform.io.Content;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.boot.buildpack.platform.io.Owner;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class EphemeralBuilder {
    static final String BUILDER_FOR_LABEL_NAME = "org.springframework.boot.builderFor";
    private ImageReference name = ImageReference.random("pack.local/builder/").inTaggedForm();
    private final BuildOwner buildOwner;
    private final Creator creator;
    private final BuilderMetadata builderMetadata;
    private final Image builderImage;
    private final IOConsumer<ImageArchive.Update> archiveUpdate;

    EphemeralBuilder(BuildOwner buildOwner, Image builderImage, ImageReference targetImage, BuilderMetadata builderMetadata, Creator creator, Map<String, String> env, Buildpacks buildpacks) {
        this.buildOwner = buildOwner;
        this.creator = creator;
        this.builderMetadata = builderMetadata.copy(this::updateMetadata);
        this.builderImage = builderImage;
        this.archiveUpdate = update -> {
            update.withUpdatedConfig(this.builderMetadata::attachTo);
            update.withUpdatedConfig(config -> config.withLabel(BUILDER_FOR_LABEL_NAME, targetImage.toString()));
            update.withTag(this.name);
            if (!CollectionUtils.isEmpty((Map)env)) {
                update.withNewLayer(this.getEnvLayer(env));
            }
            if (buildpacks != null) {
                buildpacks.apply(update::withNewLayer);
            }
        };
    }

    private void updateMetadata(BuilderMetadata.Update update) {
        update.withCreatedBy(this.creator.getName(), this.creator.getVersion());
    }

    private Layer getEnvLayer(Map<String, String> env) throws IOException {
        return Layer.of(layout -> {
            for (Map.Entry entry : env.entrySet()) {
                String name = "/platform/env/" + (String)entry.getKey();
                Content content = Content.of(entry.getValue() != null ? (String)entry.getValue() : "");
                layout.file(name, Owner.ROOT, content);
            }
        });
    }

    ImageReference getName() {
        return this.name;
    }

    Owner getBuildOwner() {
        return this.buildOwner;
    }

    BuilderMetadata getBuilderMetadata() {
        return this.builderMetadata;
    }

    ImageArchive getArchive(String applicationDirectory) throws IOException {
        return ImageArchive.from(this.builderImage, update -> {
            this.archiveUpdate.accept((ImageArchive.Update)update);
            if (StringUtils.hasLength((String)applicationDirectory)) {
                update.withNewLayer(this.applicationDirectoryLayer(applicationDirectory));
            }
        });
    }

    private Layer applicationDirectoryLayer(String applicationDirectory) throws IOException {
        return Layer.of(layout -> layout.directory(applicationDirectory, this.buildOwner));
    }

    public String toString() {
        return this.name.toString();
    }
}

