/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.springframework.boot.buildpack.platform.docker.type.LayerId;
import org.springframework.boot.buildpack.platform.io.Content;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.boot.buildpack.platform.io.InspectedContent;
import org.springframework.boot.buildpack.platform.io.Layout;
import org.springframework.boot.buildpack.platform.io.TarArchive;
import org.springframework.util.Assert;

public class Layer
implements Content {
    private final Content content;
    private final LayerId id;

    Layer(TarArchive tarArchive) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        InspectedContent.Inspector[] inspectorArray = new InspectedContent.Inspector[1];
        inspectorArray[0] = digest::update;
        this.content = InspectedContent.of(tarArchive::writeTo, inspectorArray);
        this.id = LayerId.ofSha256Digest(digest.digest());
    }

    public LayerId getId() {
        return this.id;
    }

    @Override
    public int size() {
        return this.content.size();
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.content.writeTo(outputStream);
    }

    public static Layer of(IOConsumer<Layout> layout) throws IOException {
        Assert.notNull(layout, (String)"Layout must not be null");
        return Layer.fromTarArchive(TarArchive.of(layout));
    }

    public static Layer fromTarArchive(TarArchive tarArchive) throws IOException {
        Assert.notNull((Object)tarArchive, (String)"TarArchive must not be null");
        try {
            return new Layer(tarArchive);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

