/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import org.springframework.boot.buildpack.platform.json.MappedObject;

public class ContainerStatus
extends MappedObject {
    private final int statusCode;
    private final String waitingErrorMessage;

    ContainerStatus(int statusCode, String waitingErrorMessage) {
        super(null, null);
        this.statusCode = statusCode;
        this.waitingErrorMessage = waitingErrorMessage;
    }

    ContainerStatus(JsonNode node) {
        super(node, MethodHandles.lookup());
        this.statusCode = this.valueAt("/StatusCode", Integer.class);
        this.waitingErrorMessage = this.valueAt("/Error/Message", String.class);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getWaitingErrorMessage() {
        return this.waitingErrorMessage;
    }

    public static ContainerStatus of(InputStream content) throws IOException {
        return ContainerStatus.of(content, ContainerStatus::new);
    }

    public static ContainerStatus of(int statusCode, String errorMessage) {
        return new ContainerStatus(statusCode, errorMessage);
    }
}

