/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.springframework.boot.buildpack.platform.docker.transport.DockerConnectionException;
import org.springframework.boot.buildpack.platform.docker.transport.DockerEngineException;
import org.springframework.boot.buildpack.platform.docker.transport.Errors;
import org.springframework.boot.buildpack.platform.docker.transport.HttpTransport;
import org.springframework.boot.buildpack.platform.docker.transport.Message;
import org.springframework.boot.buildpack.platform.io.IOConsumer;
import org.springframework.boot.buildpack.platform.json.SharedObjectMapper;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class HttpClientTransport
implements HttpTransport {
    static final String REGISTRY_AUTH_HEADER = "X-Registry-Auth";
    private final HttpClient client;
    private final HttpHost host;

    protected HttpClientTransport(HttpClient client, HttpHost host) {
        Assert.notNull((Object)client, (String)"Client must not be null");
        Assert.notNull((Object)host, (String)"Host must not be null");
        this.client = client;
        this.host = host;
    }

    @Override
    public HttpTransport.Response get(URI uri) {
        return this.execute((HttpUriRequest)new HttpGet(uri));
    }

    @Override
    public HttpTransport.Response post(URI uri) {
        return this.execute((HttpUriRequest)new HttpPost(uri));
    }

    @Override
    public HttpTransport.Response post(URI uri, String registryAuth) {
        return this.execute((HttpUriRequestBase)new HttpPost(uri), registryAuth);
    }

    @Override
    public HttpTransport.Response post(URI uri, String contentType, IOConsumer<OutputStream> writer) {
        return this.execute((HttpUriRequestBase)new HttpPost(uri), contentType, writer);
    }

    @Override
    public HttpTransport.Response put(URI uri, String contentType, IOConsumer<OutputStream> writer) {
        return this.execute((HttpUriRequestBase)new HttpPut(uri), contentType, writer);
    }

    @Override
    public HttpTransport.Response delete(URI uri) {
        return this.execute((HttpUriRequest)new HttpDelete(uri));
    }

    @Override
    public HttpTransport.Response head(URI uri) {
        return this.execute((HttpUriRequest)new HttpHead(uri));
    }

    private HttpTransport.Response execute(HttpUriRequestBase request, String contentType, IOConsumer<OutputStream> writer) {
        request.setEntity((HttpEntity)new WritableHttpEntity(contentType, writer));
        return this.execute((HttpUriRequest)request);
    }

    private HttpTransport.Response execute(HttpUriRequestBase request, String registryAuth) {
        if (StringUtils.hasText((String)registryAuth)) {
            request.setHeader(REGISTRY_AUTH_HEADER, (Object)registryAuth);
        }
        return this.execute((HttpUriRequest)request);
    }

    private HttpTransport.Response execute(HttpUriRequest request) {
        try {
            this.beforeExecute((HttpRequest)request);
            ClassicHttpResponse response = this.client.executeOpen(this.host, (ClassicHttpRequest)request, null);
            int statusCode = response.getCode();
            if (statusCode >= 400 && statusCode <= 500) {
                byte[] content = this.readContent(response);
                response.close();
                Errors errors = statusCode != 500 ? this.deserializeErrors(content) : null;
                Message message = this.deserializeMessage(content);
                throw new DockerEngineException(this.host.toHostString(), request.getUri(), statusCode, response.getReasonPhrase(), errors, message);
            }
            return new HttpClientResponse(response);
        }
        catch (IOException | URISyntaxException ex) {
            throw new DockerConnectionException(this.host.toHostString(), ex);
        }
    }

    protected void beforeExecute(HttpRequest request) {
    }

    private byte[] readContent(ClassicHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return null;
        }
        try (InputStream stream = entity.getContent();){
            byte[] byArray = stream != null ? stream.readAllBytes() : null;
            return byArray;
        }
    }

    private Errors deserializeErrors(byte[] content) {
        if (content == null) {
            return null;
        }
        try {
            return (Errors)SharedObjectMapper.get().readValue(content, Errors.class);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private Message deserializeMessage(byte[] content) {
        if (content == null) {
            return null;
        }
        try {
            Message message = (Message)SharedObjectMapper.get().readValue(content, Message.class);
            return message.getMessage() != null ? message : null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    HttpHost getHost() {
        return this.host;
    }

    private static class WritableHttpEntity
    extends AbstractHttpEntity {
        private final IOConsumer<OutputStream> writer;

        WritableHttpEntity(String contentType, IOConsumer<OutputStream> writer) {
            super(contentType, "UTF-8");
            this.writer = writer;
        }

        public boolean isRepeatable() {
            return false;
        }

        public long getContentLength() {
            if (this.getContentType() != null && this.getContentType().equals("application/json")) {
                return this.calculateStringContentLength();
            }
            return -1L;
        }

        public InputStream getContent() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            this.writer.accept(outputStream);
        }

        public boolean isStreaming() {
            return true;
        }

        private int calculateStringContentLength() {
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                this.writer.accept(bytes);
                return bytes.toByteArray().length;
            }
            catch (IOException ex) {
                return -1;
            }
        }

        public void close() throws IOException {
        }
    }

    private static class HttpClientResponse
    implements HttpTransport.Response {
        private final ClassicHttpResponse response;

        HttpClientResponse(ClassicHttpResponse response) {
            this.response = response;
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.response.getEntity().getContent();
        }

        @Override
        public Header getHeader(String name) {
            return this.response.getFirstHeader(name);
        }

        @Override
        public void close() throws IOException {
            this.response.close();
        }
    }
}

