/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigureprocessor;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.springframework.boot.autoconfigureprocessor.Elements;

@SupportedAnnotationTypes(value={"org.springframework.boot.autoconfigure.condition.ConditionalOnClass", "org.springframework.boot.autoconfigure.condition.ConditionalOnBean", "org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate", "org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication", "org.springframework.boot.autoconfigure.AutoConfigureBefore", "org.springframework.boot.autoconfigure.AutoConfigureAfter", "org.springframework.boot.autoconfigure.AutoConfigureOrder", "org.springframework.boot.autoconfigure.AutoConfiguration"})
public class AutoConfigureAnnotationProcessor
extends AbstractProcessor {
    protected static final String PROPERTIES_PATH = "META-INF/spring-autoconfigure-metadata.properties";
    private final Map<String, String> properties = new TreeMap<String, String>();
    private final List<PropertyGenerator> propertyGenerators = Collections.unmodifiableList(this.getPropertyGenerators());

    protected List<PropertyGenerator> getPropertyGenerators() {
        ArrayList<PropertyGenerator> generators = new ArrayList<PropertyGenerator>();
        this.addConditionPropertyGenerators(generators);
        this.addAutoConfigurePropertyGenerators(generators);
        return generators;
    }

    private void addConditionPropertyGenerators(List<PropertyGenerator> generators) {
        String annotationPackage = "org.springframework.boot.autoconfigure.condition";
        generators.add(PropertyGenerator.of(annotationPackage, "ConditionalOnClass").withAnnotation(new OnClassConditionValueExtractor()));
        generators.add(PropertyGenerator.of(annotationPackage, "ConditionalOnBean").withAnnotation(new OnBeanConditionValueExtractor()));
        generators.add(PropertyGenerator.of(annotationPackage, "ConditionalOnSingleCandidate").withAnnotation(new OnBeanConditionValueExtractor()));
        generators.add(PropertyGenerator.of(annotationPackage, "ConditionalOnWebApplication").withAnnotation(ValueExtractor.allFrom("type")));
    }

    private void addAutoConfigurePropertyGenerators(List<PropertyGenerator> generators) {
        String annotationPackage = "org.springframework.boot.autoconfigure";
        generators.add(PropertyGenerator.of(annotationPackage, "AutoConfigureBefore", true).withAnnotation(ValueExtractor.allFrom("value", "name")).withAnnotation("AutoConfiguration", ValueExtractor.allFrom("before", "beforeName")));
        generators.add(PropertyGenerator.of(annotationPackage, "AutoConfigureAfter", true).withAnnotation(ValueExtractor.allFrom("value", "name")).withAnnotation("AutoConfiguration", ValueExtractor.allFrom("after", "afterName")));
        generators.add(PropertyGenerator.of(annotationPackage, "AutoConfigureOrder").withAnnotation(ValueExtractor.allFrom("value")));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (PropertyGenerator generator : this.propertyGenerators) {
            this.process(roundEnv, generator);
        }
        if (roundEnv.processingOver()) {
            try {
                this.writeProperties();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to write metadata", ex);
            }
        }
        return false;
    }

    private void process(RoundEnvironment roundEnv, PropertyGenerator generator) {
        for (String annotationName : generator.getSupportedAnnotations()) {
            TypeElement annotationType = this.processingEnv.getElementUtils().getTypeElement(annotationName);
            if (annotationType == null) continue;
            for (Element element : roundEnv.getElementsAnnotatedWith(annotationType)) {
                this.processElement(element, generator, annotationName);
            }
        }
    }

    private void processElement(Element element, PropertyGenerator generator, String annotationName) {
        try {
            String qualifiedName = Elements.getQualifiedName(element);
            AnnotationMirror annotation = this.getAnnotation(element, annotationName);
            if (qualifiedName != null && annotation != null) {
                List<Object> values = this.getValues(generator, annotationName, annotation);
                generator.applyToProperties(this.properties, qualifiedName, values);
                this.properties.put(qualifiedName, "");
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error processing configuration meta-data on " + String.valueOf(element), ex);
        }
    }

    private AnnotationMirror getAnnotation(Element element, String type) {
        if (element != null) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!type.equals(annotationMirror.getAnnotationType().toString())) continue;
                return annotationMirror;
            }
        }
        return null;
    }

    private List<Object> getValues(PropertyGenerator generator, String annotationName, AnnotationMirror annotation) {
        ValueExtractor extractor = generator.getValueExtractor(annotationName);
        if (extractor == null) {
            return Collections.emptyList();
        }
        return extractor.getValues(annotation);
    }

    private void writeProperties() throws IOException {
        if (!this.properties.isEmpty()) {
            Filer filer = this.processingEnv.getFiler();
            FileObject file = filer.createResource(StandardLocation.CLASS_OUTPUT, "", PROPERTIES_PATH, new Element[0]);
            try (OutputStreamWriter writer = new OutputStreamWriter(file.openOutputStream(), StandardCharsets.UTF_8);){
                for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                    ((Writer)writer).append(entry.getKey());
                    ((Writer)writer).append("=");
                    ((Writer)writer).append(entry.getValue());
                    ((Writer)writer).append(System.lineSeparator());
                }
            }
        }
    }

    static final class PropertyGenerator {
        private final String annotationPackage;
        private final String propertyName;
        private final boolean omitEmptyValues;
        private final Map<String, ValueExtractor> valueExtractors;

        private PropertyGenerator(String annotationPackage, String propertyName, boolean omitEmptyValues, Map<String, ValueExtractor> valueExtractors) {
            this.annotationPackage = annotationPackage;
            this.propertyName = propertyName;
            this.omitEmptyValues = omitEmptyValues;
            this.valueExtractors = valueExtractors;
        }

        PropertyGenerator withAnnotation(ValueExtractor valueExtractor) {
            return this.withAnnotation(this.propertyName, valueExtractor);
        }

        PropertyGenerator withAnnotation(String name, ValueExtractor ValueExtractor2) {
            LinkedHashMap<String, ValueExtractor> valueExtractors = new LinkedHashMap<String, ValueExtractor>(this.valueExtractors);
            valueExtractors.put(this.annotationPackage + "." + name, ValueExtractor2);
            return new PropertyGenerator(this.annotationPackage, this.propertyName, this.omitEmptyValues, valueExtractors);
        }

        Set<String> getSupportedAnnotations() {
            return this.valueExtractors.keySet();
        }

        ValueExtractor getValueExtractor(String annotation) {
            return this.valueExtractors.get(annotation);
        }

        void applyToProperties(Map<String, String> properties, String className, List<Object> annotationValues) {
            if (this.omitEmptyValues && annotationValues.isEmpty()) {
                return;
            }
            this.mergeProperties(properties, className + "." + this.propertyName, this.toCommaDelimitedString(annotationValues));
        }

        private void mergeProperties(Map<String, String> properties, String key, String value) {
            String existingKey = properties.get(key);
            if (existingKey == null || existingKey.isEmpty()) {
                properties.put(key, value);
            } else if (!value.isEmpty()) {
                properties.put(key, existingKey + "," + value);
            }
        }

        private String toCommaDelimitedString(List<Object> list) {
            if (list.isEmpty()) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            for (Object item : list) {
                result.append(!result.isEmpty() ? "," : "");
                result.append(item);
            }
            return result.toString();
        }

        static PropertyGenerator of(String annotationPackage, String propertyName) {
            return PropertyGenerator.of(annotationPackage, propertyName, false);
        }

        static PropertyGenerator of(String annotationPackage, String propertyName, boolean omitEmptyValues) {
            return new PropertyGenerator(annotationPackage, propertyName, omitEmptyValues, Collections.emptyMap());
        }
    }

    static class OnClassConditionValueExtractor
    extends NamedValuesExtractor {
        OnClassConditionValueExtractor() {
            super("value", "name");
        }

        @Override
        public List<Object> getValues(AnnotationMirror annotation) {
            List<Object> values = super.getValues(annotation);
            values.sort(this::compare);
            return values;
        }

        private int compare(Object o1, Object o2) {
            return Comparator.comparing(this::isSpringClass).thenComparing(String.CASE_INSENSITIVE_ORDER).compare(o1.toString(), o2.toString());
        }

        private boolean isSpringClass(String type) {
            return type.startsWith("org.springframework");
        }
    }

    @FunctionalInterface
    static interface ValueExtractor {
        public List<Object> getValues(AnnotationMirror var1);

        public static ValueExtractor allFrom(String ... names) {
            return new NamedValuesExtractor(names);
        }
    }

    static class OnBeanConditionValueExtractor
    extends AbstractValueExtractor {
        OnBeanConditionValueExtractor() {
        }

        @Override
        public List<Object> getValues(AnnotationMirror annotation) {
            LinkedHashMap attributes = new LinkedHashMap();
            annotation.getElementValues().forEach((key, value) -> attributes.put(key.getSimpleName().toString(), value));
            if (attributes.containsKey("name")) {
                return Collections.emptyList();
            }
            ArrayList<Object> result = new ArrayList<Object>();
            this.extractValues((AnnotationValue)attributes.get("value")).forEach(result::add);
            this.extractValues((AnnotationValue)attributes.get("type")).forEach(result::add);
            return result;
        }
    }

    private static class NamedValuesExtractor
    extends AbstractValueExtractor {
        private final Set<String> names;

        NamedValuesExtractor(String ... names) {
            this.names = new HashSet<String>(Arrays.asList(names));
        }

        @Override
        public List<Object> getValues(AnnotationMirror annotation) {
            ArrayList<Object> result = new ArrayList<Object>();
            annotation.getElementValues().forEach((key, value) -> {
                if (this.names.contains(key.getSimpleName().toString())) {
                    this.extractValues((AnnotationValue)value).forEach(result::add);
                }
            });
            return result;
        }
    }

    private static abstract class AbstractValueExtractor
    implements ValueExtractor {
        private AbstractValueExtractor() {
        }

        protected Stream<Object> extractValues(AnnotationValue annotationValue) {
            if (annotationValue == null) {
                return Stream.empty();
            }
            Object value = annotationValue.getValue();
            if (value instanceof List) {
                return ((List)value).stream().map(annotation -> this.extractValue(annotation.getValue()));
            }
            return Stream.of(this.extractValue(value));
        }

        private Object extractValue(Object value) {
            if (value instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)value;
                return Elements.getQualifiedName(declaredType.asElement());
            }
            return value;
        }
    }
}

