/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.amqp.autoconfigure;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.boot.retry.RetryPolicySettings;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(value="spring.rabbitmq")
public class RabbitProperties {
    private static final int DEFAULT_PORT = 5672;
    private static final int DEFAULT_PORT_SECURE = 5671;
    private static final int DEFAULT_STREAM_PORT = 5552;
    private String host = "localhost";
    private @Nullable Integer port;
    private String username = "guest";
    private String password = "guest";
    private final Ssl ssl = new Ssl();
    private @Nullable String virtualHost;
    private @Nullable List<String> addresses;
    private AbstractConnectionFactory.AddressShuffleMode addressShuffleMode = AbstractConnectionFactory.AddressShuffleMode.NONE;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private @Nullable Duration requestedHeartbeat;
    private int requestedChannelMax = 2047;
    private boolean publisherReturns;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CachingConnectionFactory.ConfirmType publisherConfirmType;
    private @Nullable Duration connectionTimeout;
    private Duration channelRpcTimeout = Duration.ofMinutes(10L);
    private DataSize maxInboundMessageBodySize = DataSize.ofMegabytes((long)64L);
    private final Cache cache = new Cache();
    private final Listener listener = new Listener();
    private final Template template = new Template();
    private final Stream stream = new Stream();
    private @Nullable List<Address> parsedAddresses;

    public String getHost() {
        return this.host;
    }

    public String determineHost() {
        if (CollectionUtils.isEmpty(this.parsedAddresses)) {
            return this.getHost();
        }
        return this.parsedAddresses.get((int)0).host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public @Nullable Integer getPort() {
        return this.port;
    }

    public int determinePort() {
        if (CollectionUtils.isEmpty(this.parsedAddresses)) {
            Integer port = this.getPort();
            if (port != null) {
                return port;
            }
            return Boolean.TRUE.equals(this.getSsl().getEnabled()) ? 5671 : 5672;
        }
        return this.parsedAddresses.get((int)0).port;
    }

    public void setPort(@Nullable Integer port) {
        this.port = port;
    }

    public @Nullable List<String> getAddresses() {
        return this.addresses;
    }

    public List<String> determineAddresses() {
        if (CollectionUtils.isEmpty(this.parsedAddresses)) {
            if (this.host.contains(",")) {
                throw new InvalidConfigurationPropertyValueException("spring.rabbitmq.host", (Object)this.host, "Invalid character ','. Value must be a single host. For multiple hosts, use property 'spring.rabbitmq.addresses' instead.");
            }
            return List.of(this.host + ":" + this.determinePort());
        }
        ArrayList<String> addressStrings = new ArrayList<String>();
        for (Address parsedAddress : this.parsedAddresses) {
            addressStrings.add(parsedAddress.host + ":" + parsedAddress.port);
        }
        return addressStrings;
    }

    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
        this.parsedAddresses = this.parseAddresses(addresses);
    }

    private List<Address> parseAddresses(List<String> addresses) {
        ArrayList<Address> parsedAddresses = new ArrayList<Address>();
        for (String address : addresses) {
            parsedAddresses.add(new Address(address, Boolean.TRUE.equals(this.getSsl().getEnabled())));
        }
        return parsedAddresses;
    }

    public String getUsername() {
        return this.username;
    }

    public String determineUsername() {
        if (CollectionUtils.isEmpty(this.parsedAddresses)) {
            return this.username;
        }
        Address address = this.parsedAddresses.get(0);
        return address.username != null ? address.username : this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public @Nullable String determinePassword() {
        if (CollectionUtils.isEmpty(this.parsedAddresses)) {
            return this.getPassword();
        }
        Address address = this.parsedAddresses.get(0);
        return address.password != null ? address.password : this.getPassword();
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public @Nullable String getVirtualHost() {
        return this.virtualHost;
    }

    public @Nullable String determineVirtualHost() {
        if (CollectionUtils.isEmpty(this.parsedAddresses)) {
            return this.getVirtualHost();
        }
        Address address = this.parsedAddresses.get(0);
        return address.virtualHost != null ? address.virtualHost : this.getVirtualHost();
    }

    public void setVirtualHost(@Nullable String virtualHost) {
        this.virtualHost = StringUtils.hasText((String)virtualHost) ? virtualHost : "/";
    }

    public AbstractConnectionFactory.AddressShuffleMode getAddressShuffleMode() {
        return this.addressShuffleMode;
    }

    public void setAddressShuffleMode(AbstractConnectionFactory.AddressShuffleMode addressShuffleMode) {
        this.addressShuffleMode = addressShuffleMode;
    }

    public @Nullable Duration getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public void setRequestedHeartbeat(@Nullable Duration requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
    }

    public int getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public void setRequestedChannelMax(int requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
    }

    public boolean isPublisherReturns() {
        return this.publisherReturns;
    }

    public void setPublisherReturns(boolean publisherReturns) {
        this.publisherReturns = publisherReturns;
    }

    public @Nullable Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setPublisherConfirmType(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CachingConnectionFactory.ConfirmType publisherConfirmType) {
        this.publisherConfirmType = publisherConfirmType;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CachingConnectionFactory.ConfirmType getPublisherConfirmType() {
        return this.publisherConfirmType;
    }

    public void setConnectionTimeout(@Nullable Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Duration getChannelRpcTimeout() {
        return this.channelRpcTimeout;
    }

    public void setChannelRpcTimeout(Duration channelRpcTimeout) {
        this.channelRpcTimeout = channelRpcTimeout;
    }

    public DataSize getMaxInboundMessageBodySize() {
        return this.maxInboundMessageBodySize;
    }

    public void setMaxInboundMessageBodySize(DataSize maxInboundMessageBodySize) {
        this.maxInboundMessageBodySize = maxInboundMessageBodySize;
    }

    public Cache getCache() {
        return this.cache;
    }

    public Listener getListener() {
        return this.listener;
    }

    public Template getTemplate() {
        return this.template;
    }

    public Stream getStream() {
        return this.stream;
    }

    public class Ssl {
        private static final String SUN_X509 = "SunX509";
        private @Nullable Boolean enabled;
        private @Nullable String bundle;
        private @Nullable String keyStore;
        private String keyStoreType = "PKCS12";
        private @Nullable String keyStorePassword;
        private String keyStoreAlgorithm = "SunX509";
        private @Nullable String trustStore;
        private String trustStoreType = "JKS";
        private @Nullable String trustStorePassword;
        private String trustStoreAlgorithm = "SunX509";
        private @Nullable String algorithm;
        private boolean validateServerCertificate = true;
        private boolean verifyHostname = true;

        public @Nullable Boolean getEnabled() {
            return this.enabled;
        }

        public boolean determineEnabled() {
            boolean defaultEnabled;
            boolean bl = defaultEnabled = Boolean.TRUE.equals(this.getEnabled()) || this.bundle != null;
            if (CollectionUtils.isEmpty(RabbitProperties.this.parsedAddresses)) {
                return defaultEnabled;
            }
            Address address = RabbitProperties.this.parsedAddresses.get(0);
            return address.determineSslEnabled(defaultEnabled);
        }

        public void setEnabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
        }

        public @Nullable String getBundle() {
            return this.bundle;
        }

        public void setBundle(@Nullable String bundle) {
            this.bundle = bundle;
        }

        public @Nullable String getKeyStore() {
            return this.keyStore;
        }

        public void setKeyStore(@Nullable String keyStore) {
            this.keyStore = keyStore;
        }

        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public void setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
        }

        public @Nullable String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(@Nullable String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public String getKeyStoreAlgorithm() {
            return this.keyStoreAlgorithm;
        }

        public void setKeyStoreAlgorithm(String keyStoreAlgorithm) {
            this.keyStoreAlgorithm = keyStoreAlgorithm;
        }

        public @Nullable String getTrustStore() {
            return this.trustStore;
        }

        public void setTrustStore(@Nullable String trustStore) {
            this.trustStore = trustStore;
        }

        public String getTrustStoreType() {
            return this.trustStoreType;
        }

        public void setTrustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
        }

        public @Nullable String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(@Nullable String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        public String getTrustStoreAlgorithm() {
            return this.trustStoreAlgorithm;
        }

        public void setTrustStoreAlgorithm(String trustStoreAlgorithm) {
            this.trustStoreAlgorithm = trustStoreAlgorithm;
        }

        public @Nullable String getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(@Nullable String sslAlgorithm) {
            this.algorithm = sslAlgorithm;
        }

        public boolean isValidateServerCertificate() {
            return this.validateServerCertificate;
        }

        public void setValidateServerCertificate(boolean validateServerCertificate) {
            this.validateServerCertificate = validateServerCertificate;
        }

        public boolean isVerifyHostname() {
            return this.verifyHostname;
        }

        public void setVerifyHostname(boolean verifyHostname) {
            this.verifyHostname = verifyHostname;
        }
    }

    public static class Cache {
        private final Channel channel = new Channel();
        private final Connection connection = new Connection();

        public Channel getChannel() {
            return this.channel;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public static class Channel {
            private @Nullable Integer size;
            private @Nullable Duration checkoutTimeout;

            public @Nullable Integer getSize() {
                return this.size;
            }

            public void setSize(@Nullable Integer size) {
                this.size = size;
            }

            public @Nullable Duration getCheckoutTimeout() {
                return this.checkoutTimeout;
            }

            public void setCheckoutTimeout(@Nullable Duration checkoutTimeout) {
                this.checkoutTimeout = checkoutTimeout;
            }
        }

        public static class Connection {
            private CachingConnectionFactory.CacheMode mode = CachingConnectionFactory.CacheMode.CHANNEL;
            private @Nullable Integer size;

            public CachingConnectionFactory.CacheMode getMode() {
                return this.mode;
            }

            public void setMode(CachingConnectionFactory.CacheMode mode) {
                this.mode = mode;
            }

            public @Nullable Integer getSize() {
                return this.size;
            }

            public void setSize(@Nullable Integer size) {
                this.size = size;
            }
        }
    }

    public static class Listener {
        private ContainerType type = ContainerType.SIMPLE;
        private final SimpleContainer simple = new SimpleContainer();
        private final DirectContainer direct = new DirectContainer();
        private final StreamContainer stream = new StreamContainer();

        public ContainerType getType() {
            return this.type;
        }

        public void setType(ContainerType containerType) {
            this.type = containerType;
        }

        public SimpleContainer getSimple() {
            return this.simple;
        }

        public DirectContainer getDirect() {
            return this.direct;
        }

        public StreamContainer getStream() {
            return this.stream;
        }
    }

    public static class Template {
        private final Retry retry = new Retry();
        private @Nullable Boolean mandatory;
        private @Nullable Duration receiveTimeout;
        private @Nullable Duration replyTimeout;
        private String exchange = "";
        private String routingKey = "";
        private @Nullable String defaultReceiveQueue;
        private boolean observationEnabled;
        private @Nullable List<String> allowedListPatterns;

        public Retry getRetry() {
            return this.retry;
        }

        public @Nullable Boolean getMandatory() {
            return this.mandatory;
        }

        public void setMandatory(@Nullable Boolean mandatory) {
            this.mandatory = mandatory;
        }

        public @Nullable Duration getReceiveTimeout() {
            return this.receiveTimeout;
        }

        public void setReceiveTimeout(@Nullable Duration receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
        }

        public @Nullable Duration getReplyTimeout() {
            return this.replyTimeout;
        }

        public void setReplyTimeout(@Nullable Duration replyTimeout) {
            this.replyTimeout = replyTimeout;
        }

        public String getExchange() {
            return this.exchange;
        }

        public void setExchange(String exchange) {
            this.exchange = exchange;
        }

        public String getRoutingKey() {
            return this.routingKey;
        }

        public void setRoutingKey(String routingKey) {
            this.routingKey = routingKey;
        }

        public @Nullable String getDefaultReceiveQueue() {
            return this.defaultReceiveQueue;
        }

        public void setDefaultReceiveQueue(@Nullable String defaultReceiveQueue) {
            this.defaultReceiveQueue = defaultReceiveQueue;
        }

        public boolean isObservationEnabled() {
            return this.observationEnabled;
        }

        public void setObservationEnabled(boolean observationEnabled) {
            this.observationEnabled = observationEnabled;
        }

        public @Nullable List<String> getAllowedListPatterns() {
            return this.allowedListPatterns;
        }

        public void setAllowedListPatterns(@Nullable List<String> allowedListPatterns) {
            this.allowedListPatterns = allowedListPatterns;
        }
    }

    public static final class Stream {
        private String host = "localhost";
        private int port = 5552;
        private @Nullable String virtualHost;
        private @Nullable String username;
        private @Nullable String password;
        private @Nullable String name;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public @Nullable String getVirtualHost() {
            return this.virtualHost;
        }

        public void setVirtualHost(@Nullable String virtualHost) {
            this.virtualHost = virtualHost;
        }

        public @Nullable String getUsername() {
            return this.username;
        }

        public void setUsername(@Nullable String username) {
            this.username = username;
        }

        public @Nullable String getPassword() {
            return this.password;
        }

        public void setPassword(@Nullable String password) {
            this.password = password;
        }

        public @Nullable String getName() {
            return this.name;
        }

        public void setName(@Nullable String name) {
            this.name = name;
        }
    }

    private static final class Address {
        private static final String PREFIX_AMQP = "amqp://";
        private static final String PREFIX_AMQP_SECURE = "amqps://";
        private String host;
        private int port;
        private @Nullable String username;
        private @Nullable String password;
        private @Nullable String virtualHost;
        private @Nullable Boolean secureConnection;

        private Address(String input, boolean sslEnabled) {
            input = input.trim();
            input = this.trimPrefix(input);
            input = this.parseUsernameAndPassword(input);
            input = this.parseVirtualHost(input);
            this.parseHostAndPort(input, sslEnabled);
        }

        private String trimPrefix(String input) {
            if (input.startsWith(PREFIX_AMQP_SECURE)) {
                this.secureConnection = true;
                return input.substring(PREFIX_AMQP_SECURE.length());
            }
            if (input.startsWith(PREFIX_AMQP)) {
                this.secureConnection = false;
                return input.substring(PREFIX_AMQP.length());
            }
            return input;
        }

        private String parseUsernameAndPassword(String input) {
            String[] splitInput = StringUtils.split((String)input, (String)"@");
            if (splitInput == null) {
                return input;
            }
            String credentials = splitInput[0];
            String[] splitCredentials = StringUtils.split((String)credentials, (String)":");
            if (splitCredentials == null) {
                this.username = credentials;
            } else {
                this.username = splitCredentials[0];
                this.password = splitCredentials[1];
            }
            return splitInput[1];
        }

        private String parseVirtualHost(String input) {
            int hostIndex = input.indexOf(47);
            if (hostIndex >= 0) {
                this.virtualHost = input.substring(hostIndex + 1);
                if (this.virtualHost.isEmpty()) {
                    this.virtualHost = "/";
                }
                input = input.substring(0, hostIndex);
            }
            return input;
        }

        private void parseHostAndPort(String input, boolean sslEnabled) {
            int bracketIndex = input.lastIndexOf(93);
            int colonIndex = input.lastIndexOf(58);
            if (colonIndex == -1 || colonIndex < bracketIndex) {
                this.host = input;
                this.port = this.determineSslEnabled(sslEnabled) ? 5671 : 5672;
            } else {
                this.host = input.substring(0, colonIndex);
                this.port = Integer.parseInt(input.substring(colonIndex + 1));
            }
        }

        private boolean determineSslEnabled(boolean sslEnabled) {
            return this.secureConnection != null ? this.secureConnection : sslEnabled;
        }
    }

    public static class ListenerRetry
    extends Retry {
        private boolean stateless = true;

        public boolean isStateless() {
            return this.stateless;
        }

        public void setStateless(boolean stateless) {
            this.stateless = stateless;
        }
    }

    public static class Retry {
        private boolean enabled;
        private long maxAttempts = 3L;
        private Duration initialInterval = Duration.ofMillis(1000L);
        private double multiplier = 1.0;
        private Duration maxInterval = Duration.ofMillis(10000L);

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public long getMaxAttempts() {
            return this.maxAttempts;
        }

        public void setMaxAttempts(long maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public Duration getInitialInterval() {
            return this.initialInterval;
        }

        public void setInitialInterval(Duration initialInterval) {
            this.initialInterval = initialInterval;
        }

        public double getMultiplier() {
            return this.multiplier;
        }

        public void setMultiplier(double multiplier) {
            this.multiplier = multiplier;
        }

        public Duration getMaxInterval() {
            return this.maxInterval;
        }

        public void setMaxInterval(Duration maxInterval) {
            this.maxInterval = maxInterval;
        }

        RetryPolicySettings initializeRetryPolicySettings() {
            PropertyMapper map = PropertyMapper.get();
            RetryPolicySettings settings = new RetryPolicySettings();
            map.from(this::getMaxAttempts).to(arg_0 -> ((RetryPolicySettings)settings).setMaxAttempts(arg_0));
            map.from(this::getInitialInterval).to(arg_0 -> ((RetryPolicySettings)settings).setDelay(arg_0));
            map.from(this::getMultiplier).to(arg_0 -> ((RetryPolicySettings)settings).setMultiplier(arg_0));
            map.from(this::getMaxInterval).to(arg_0 -> ((RetryPolicySettings)settings).setMaxDelay(arg_0));
            return settings;
        }
    }

    public static class StreamContainer
    extends BaseContainer {
        private boolean nativeListener;

        public boolean isNativeListener() {
            return this.nativeListener;
        }

        public void setNativeListener(boolean nativeListener) {
            this.nativeListener = nativeListener;
        }
    }

    public static class DirectContainer
    extends AmqpContainer {
        private @Nullable Integer consumersPerQueue;
        private boolean missingQueuesFatal = false;

        public @Nullable Integer getConsumersPerQueue() {
            return this.consumersPerQueue;
        }

        public void setConsumersPerQueue(@Nullable Integer consumersPerQueue) {
            this.consumersPerQueue = consumersPerQueue;
        }

        @Override
        public boolean isMissingQueuesFatal() {
            return this.missingQueuesFatal;
        }

        public void setMissingQueuesFatal(boolean missingQueuesFatal) {
            this.missingQueuesFatal = missingQueuesFatal;
        }
    }

    public static class SimpleContainer
    extends AmqpContainer {
        private @Nullable Integer concurrency;
        private @Nullable Integer maxConcurrency;
        private @Nullable Integer batchSize;
        private boolean missingQueuesFatal = true;
        private boolean consumerBatchEnabled;

        public @Nullable Integer getConcurrency() {
            return this.concurrency;
        }

        public void setConcurrency(@Nullable Integer concurrency) {
            this.concurrency = concurrency;
        }

        public @Nullable Integer getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public void setMaxConcurrency(@Nullable Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public @Nullable Integer getBatchSize() {
            return this.batchSize;
        }

        public void setBatchSize(@Nullable Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public boolean isMissingQueuesFatal() {
            return this.missingQueuesFatal;
        }

        public void setMissingQueuesFatal(boolean missingQueuesFatal) {
            this.missingQueuesFatal = missingQueuesFatal;
        }

        public boolean isConsumerBatchEnabled() {
            return this.consumerBatchEnabled;
        }

        public void setConsumerBatchEnabled(boolean consumerBatchEnabled) {
            this.consumerBatchEnabled = consumerBatchEnabled;
        }
    }

    public static abstract class AmqpContainer
    extends BaseContainer {
        private boolean autoStartup = true;
        private @Nullable AcknowledgeMode acknowledgeMode;
        private @Nullable Integer prefetch;
        private @Nullable Boolean defaultRequeueRejected;
        private @Nullable Duration idleEventInterval;
        private boolean deBatchingEnabled = true;
        private boolean forceStop;
        private final ListenerRetry retry = new ListenerRetry();

        public boolean isAutoStartup() {
            return this.autoStartup;
        }

        public void setAutoStartup(boolean autoStartup) {
            this.autoStartup = autoStartup;
        }

        public @Nullable AcknowledgeMode getAcknowledgeMode() {
            return this.acknowledgeMode;
        }

        public void setAcknowledgeMode(@Nullable AcknowledgeMode acknowledgeMode) {
            this.acknowledgeMode = acknowledgeMode;
        }

        public @Nullable Integer getPrefetch() {
            return this.prefetch;
        }

        public void setPrefetch(@Nullable Integer prefetch) {
            this.prefetch = prefetch;
        }

        public @Nullable Boolean getDefaultRequeueRejected() {
            return this.defaultRequeueRejected;
        }

        public void setDefaultRequeueRejected(@Nullable Boolean defaultRequeueRejected) {
            this.defaultRequeueRejected = defaultRequeueRejected;
        }

        public @Nullable Duration getIdleEventInterval() {
            return this.idleEventInterval;
        }

        public void setIdleEventInterval(@Nullable Duration idleEventInterval) {
            this.idleEventInterval = idleEventInterval;
        }

        public abstract boolean isMissingQueuesFatal();

        public boolean isDeBatchingEnabled() {
            return this.deBatchingEnabled;
        }

        public void setDeBatchingEnabled(boolean deBatchingEnabled) {
            this.deBatchingEnabled = deBatchingEnabled;
        }

        public boolean isForceStop() {
            return this.forceStop;
        }

        public void setForceStop(boolean forceStop) {
            this.forceStop = forceStop;
        }

        public ListenerRetry getRetry() {
            return this.retry;
        }
    }

    public static abstract class BaseContainer {
        private boolean observationEnabled;

        public boolean isObservationEnabled() {
            return this.observationEnabled;
        }

        public void setObservationEnabled(boolean observationEnabled) {
            this.observationEnabled = observationEnabled;
        }
    }

    public static enum ContainerType {
        SIMPLE,
        DIRECT,
        STREAM;

    }
}

