/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.web.context.reactive.ConfigurableReactiveWebApplicationContext;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;

class OnManagementPortCondition
extends SpringBootCondition {
    private static final String CLASS_NAME_WEB_APPLICATION_CONTEXT = "org.springframework.web.context.WebApplicationContext";

    OnManagementPortCondition() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Management Port", (Object[])new Object[0]);
        if (!this.isWebApplicationContext(context)) {
            return ConditionOutcome.noMatch((ConditionMessage)message.because("non web application context"));
        }
        @Nullable Map attributes = metadata.getAnnotationAttributes(ConditionalOnManagementPort.class.getName());
        Assert.state((attributes != null ? 1 : 0) != 0, (String)"'attributes' must not be null");
        ManagementPortType requiredType = (ManagementPortType)((Object)attributes.get("value"));
        ManagementPortType actualType = ManagementPortType.get(context.getEnvironment());
        if (actualType == requiredType) {
            return ConditionOutcome.match((ConditionMessage)message.because("actual port type (" + String.valueOf((Object)actualType) + ") matched required type"));
        }
        return ConditionOutcome.noMatch((ConditionMessage)message.because("actual port type (" + String.valueOf((Object)actualType) + ") did not match required type (" + String.valueOf((Object)requiredType) + ")"));
    }

    private boolean isWebApplicationContext(ConditionContext context) {
        ResourceLoader resourceLoader = context.getResourceLoader();
        if (resourceLoader instanceof ConfigurableReactiveWebApplicationContext) {
            return true;
        }
        if (!ClassUtils.isPresent((String)CLASS_NAME_WEB_APPLICATION_CONTEXT, (ClassLoader)context.getClassLoader())) {
            return false;
        }
        return resourceLoader instanceof WebApplicationContext;
    }
}

