/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.server.EnableManagementContext;
import org.springframework.boot.context.annotation.ImportCandidates;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Order(value=0x7FFFFFFF)
class ManagementContextConfigurationImportSelector
implements DeferredImportSelector,
BeanClassLoaderAware {
    private @Nullable ClassLoader classLoader;

    ManagementContextConfigurationImportSelector() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public String[] selectImports(AnnotationMetadata metadata) {
        @Nullable Map attributes = metadata.getAnnotationAttributes(EnableManagementContext.class.getName());
        Assert.state((attributes != null ? 1 : 0) != 0, (String)"'attributes' must not be null");
        ManagementContextType contextType = (ManagementContextType)((Object)attributes.get("value"));
        List<ManagementConfiguration> configurations = this.getConfigurations();
        OrderComparator.sort(configurations);
        ArrayList<String> names = new ArrayList<String>();
        for (ManagementConfiguration configuration : configurations) {
            if (configuration.getContextType() != ManagementContextType.ANY && configuration.getContextType() != contextType) continue;
            names.add(configuration.getClassName());
        }
        return StringUtils.toStringArray(names);
    }

    private List<ManagementConfiguration> getConfigurations() {
        SimpleMetadataReaderFactory readerFactory = new SimpleMetadataReaderFactory(this.classLoader);
        ArrayList<ManagementConfiguration> configurations = new ArrayList<ManagementConfiguration>();
        for (String className : this.loadFactoryNames()) {
            this.addConfiguration(readerFactory, configurations, className);
        }
        return configurations;
    }

    private void addConfiguration(SimpleMetadataReaderFactory readerFactory, List<ManagementConfiguration> configurations, String className) {
        try {
            MetadataReader metadataReader = readerFactory.getMetadataReader(className);
            configurations.add(new ManagementConfiguration(metadataReader));
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read annotation metadata for '" + className + "'", ex);
        }
    }

    protected List<String> loadFactoryNames() {
        return ImportCandidates.load(ManagementContextConfiguration.class, (ClassLoader)this.classLoader).getCandidates();
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static final class ManagementConfiguration
    implements Ordered {
        private final String className;
        private final int order;
        private final ManagementContextType contextType;

        ManagementConfiguration(MetadataReader metadataReader) {
            AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
            this.order = this.readOrder(annotationMetadata);
            this.className = metadataReader.getClassMetadata().getClassName();
            this.contextType = this.readContextType(annotationMetadata);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private ManagementContextType readContextType(AnnotationMetadata annotationMetadata) {
            @Nullable Map annotationAttributes = annotationMetadata.getAnnotationAttributes(ManagementContextConfiguration.class.getName());
            if (annotationAttributes == null) {
                return ManagementContextType.ANY;
            }
            ManagementContextType value = (ManagementContextType)((Object)annotationAttributes.get("value"));
            Assert.state((value != null ? 1 : 0) != 0, (String)"'value' must not be null");
            return value;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private int readOrder(AnnotationMetadata annotationMetadata) {
            @Nullable Map attributes = annotationMetadata.getAnnotationAttributes(Order.class.getName());
            Integer order = attributes != null ? (Integer)attributes.get("value") : null;
            return order != null ? order : Integer.MAX_VALUE;
        }

        String getClassName() {
            return this.className;
        }

        public int getOrder() {
            return this.order;
        }

        ManagementContextType getContextType() {
            return this.contextType;
        }
    }
}

