/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.ssl;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.MultiGauge;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.info.SslInfo;
import org.springframework.boot.ssl.SslBundles;

class SslMeterBinder
implements MeterBinder {
    private static final String CHAIN_EXPIRY_METRIC_NAME = "ssl.chain.expiry";
    private final Clock clock;
    private final SslInfo sslInfo;
    private final BundleMetrics bundleMetrics = new BundleMetrics();

    SslMeterBinder(SslInfo sslInfo, SslBundles sslBundles) {
        this(sslInfo, sslBundles, Clock.systemDefaultZone());
    }

    SslMeterBinder(SslInfo sslInfo, SslBundles sslBundles, Clock clock) {
        this.clock = clock;
        this.sslInfo = sslInfo;
        sslBundles.addBundleRegisterHandler((bundleName, ignored) -> this.onBundleChange((String)bundleName));
        for (String bundleName2 : sslBundles.getBundleNames()) {
            sslBundles.addBundleUpdateHandler(bundleName2, ignored -> this.onBundleChange(bundleName2));
        }
    }

    private void onBundleChange(String bundleName) {
        SslInfo.BundleInfo bundle = this.sslInfo.getBundle(bundleName);
        this.bundleMetrics.updateBundle(bundle);
        for (MeterRegistry meterRegistry : this.bundleMetrics.getMeterRegistries()) {
            this.createOrUpdateBundleMetrics(meterRegistry, bundle);
        }
    }

    public void bindTo(MeterRegistry meterRegistry) {
        for (SslInfo.BundleInfo bundle : this.sslInfo.getBundles()) {
            this.createOrUpdateBundleMetrics(meterRegistry, bundle);
        }
    }

    private void createOrUpdateBundleMetrics(MeterRegistry meterRegistry, SslInfo.BundleInfo bundle) {
        MultiGauge multiGauge = this.bundleMetrics.getGauge(bundle, meterRegistry);
        ArrayList<MultiGauge.Row<SslInfo.CertificateInfo>> rows = new ArrayList<MultiGauge.Row<SslInfo.CertificateInfo>>();
        for (SslInfo.CertificateChainInfo chain : bundle.getCertificateChains()) {
            MultiGauge.Row<SslInfo.CertificateInfo> row = this.createRowForChain(bundle, chain);
            if (row == null) continue;
            rows.add(row);
        }
        multiGauge.register(rows, true);
    }

    private MultiGauge.Row<SslInfo.CertificateInfo> createRowForChain(SslInfo.BundleInfo bundle, SslInfo.CertificateChainInfo chain) {
        SslInfo.CertificateInfo leastValidCertificate = chain.getCertificates().stream().min(Comparator.comparing(SslInfo.CertificateInfo::getValidityEnds)).orElse(null);
        if (leastValidCertificate == null) {
            return null;
        }
        Tags tags = Tags.of((String[])new String[]{"chain", chain.getAlias(), "bundle", bundle.getName(), "certificate", leastValidCertificate.getSerialNumber()});
        return MultiGauge.Row.of((Tags)tags, (Object)leastValidCertificate, this::getChainExpiry);
    }

    private long getChainExpiry(SslInfo.CertificateInfo certificate) {
        Duration valid = Duration.between(Instant.now(this.clock), certificate.getValidityEnds());
        return valid.get(ChronoUnit.SECONDS);
    }

    private static final class BundleMetrics {
        private final Map<String, Gauges> gauges = new ConcurrentHashMap<String, Gauges>();

        private BundleMetrics() {
        }

        MultiGauge getGauge(SslInfo.BundleInfo bundleInfo, MeterRegistry meterRegistry) {
            Gauges gauges = this.gauges.computeIfAbsent(bundleInfo.getName(), ignored -> Gauges.emptyGauges(bundleInfo));
            return gauges.getGauge(meterRegistry);
        }

        Collection<MeterRegistry> getMeterRegistries() {
            HashSet<MeterRegistry> result = new HashSet<MeterRegistry>();
            for (Gauges metrics : this.gauges.values()) {
                result.addAll(metrics.getMeterRegistries());
            }
            return result;
        }

        void updateBundle(SslInfo.BundleInfo bundle) {
            this.gauges.computeIfPresent(bundle.getName(), (key, oldValue) -> oldValue.withBundle(bundle));
        }

        private record Gauges(SslInfo.BundleInfo bundle, Map<MeterRegistry, MultiGauge> multiGauges) {
            MultiGauge getGauge(MeterRegistry meterRegistry) {
                return this.multiGauges.computeIfAbsent(meterRegistry, ignored -> this.createGauge(meterRegistry));
            }

            Gauges withBundle(SslInfo.BundleInfo bundle) {
                return new Gauges(bundle, this.multiGauges);
            }

            Set<MeterRegistry> getMeterRegistries() {
                return this.multiGauges.keySet();
            }

            private MultiGauge createGauge(MeterRegistry meterRegistry) {
                return MultiGauge.builder((String)SslMeterBinder.CHAIN_EXPIRY_METRIC_NAME).baseUnit("seconds").description("SSL chain expiry").register(meterRegistry);
            }

            static Gauges emptyGauges(SslInfo.BundleInfo bundle) {
                return new Gauges(bundle, new ConcurrentHashMap<MeterRegistry, MultiGauge>());
            }
        }
    }
}

