/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.support;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ItemProcessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CompositeItemProcessor<I, O>
implements ItemProcessor<I, O>,
InitializingBean {
    private List<? extends ItemProcessor<?, ?>> delegates;

    public CompositeItemProcessor(ItemProcessor<?, ?> ... delegates) {
        this(Arrays.asList(delegates));
    }

    public CompositeItemProcessor(List<? extends ItemProcessor<?, ?>> delegates) {
        this.delegates = delegates;
    }

    @Override
    public @Nullable O process(I item) throws Exception {
        Object result = item;
        for (ItemProcessor<?, ?> delegate : this.delegates) {
            if (result == null) {
                return null;
            }
            result = this.processItem(delegate, result);
        }
        return (O)result;
    }

    private <T> @Nullable Object processItem(ItemProcessor<T, ?> processor, Object input) throws Exception {
        return processor.process(input);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((!this.delegates.isEmpty() ? 1 : 0) != 0, (String)"The 'delegates' may not be empty");
    }

    public void setDelegates(List<? extends ItemProcessor<?, ?>> delegates) {
        this.delegates = delegates;
    }
}

