/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.database;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.ConnectionProxy;
import org.springframework.jdbc.datasource.SmartDataSource;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class ExtendedConnectionDataSourceProxy
implements SmartDataSource,
InitializingBean {
    private @Nullable DataSource dataSource;
    private @Nullable Connection closeSuppressedConnection;
    private boolean borrowedConnection = false;
    private final Lock connectionMonitor = new ReentrantLock();

    public ExtendedConnectionDataSourceProxy() {
    }

    public ExtendedConnectionDataSourceProxy(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean shouldClose(Connection connection) {
        if (this.borrowedConnection && this.isCloseSuppressionActive(connection)) {
            this.borrowedConnection = false;
        }
        return !this.isCloseSuppressionActive(connection);
    }

    public boolean isCloseSuppressionActive(Connection connection) {
        return connection.equals(this.closeSuppressedConnection);
    }

    public void startCloseSuppression(Connection connection) {
        this.connectionMonitor.lock();
        try {
            this.closeSuppressedConnection = connection;
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                this.borrowedConnection = true;
            }
        }
        finally {
            this.connectionMonitor.unlock();
        }
    }

    public void stopCloseSuppression(Connection connection) {
        this.connectionMonitor.lock();
        try {
            this.closeSuppressedConnection = null;
            this.borrowedConnection = false;
        }
        finally {
            this.connectionMonitor.unlock();
        }
    }

    public Connection getConnection() throws SQLException {
        this.connectionMonitor.lock();
        try {
            Connection connection = this.initConnection(null, null);
            return connection;
        }
        finally {
            this.connectionMonitor.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String username, String password) throws SQLException {
        this.connectionMonitor.lock();
        try {
            Connection connection = this.initConnection(username, password);
            return connection;
        }
        finally {
            this.connectionMonitor.unlock();
        }
    }

    private Connection initConnection(@Nullable String username, @Nullable String password) throws SQLException {
        if (this.closeSuppressedConnection != null && !this.borrowedConnection) {
            this.borrowedConnection = true;
            return this.closeSuppressedConnection;
        }
        Connection target = username != null ? this.dataSource.getConnection(username, password) : this.dataSource.getConnection();
        return this.getCloseSuppressingConnectionProxy(target);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    protected Connection getCloseSuppressingConnectionProxy(Connection target) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(target, this));
    }

    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(SmartDataSource.class) || iface.isAssignableFrom(this.dataSource.getClass());
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(SmartDataSource.class)) {
            ExtendedConnectionDataSourceProxy casted = this;
            return (T)casted;
        }
        if (iface.isAssignableFrom(this.dataSource.getClass())) {
            DataSource casted = this.dataSource;
            return (T)casted;
        }
        throw new SQLException("Unsupported class " + iface.getSimpleName());
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.dataSource != null ? 1 : 0) != 0, (String)"DataSource is required");
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;
        private final ExtendedConnectionDataSourceProxy dataSource;

        public CloseSuppressingInvocationHandler(Connection target, ExtendedConnectionDataSourceProxy dataSource) {
            this.dataSource = dataSource;
            this.target = target;
        }

        @Override
        public @Nullable Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "equals": {
                    return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "close": {
                    if (this.dataSource.shouldClose((Connection)proxy)) {
                        this.target.close();
                    }
                    return null;
                }
                case "getTargetConnection": {
                    return this.target;
                }
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

