/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.data.builder;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.data.MongoItemWriter;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.util.Assert;

public class MongoItemWriterBuilder<T> {
    private @Nullable MongoOperations template;
    private @Nullable String collection;
    private MongoItemWriter.Mode mode = MongoItemWriter.Mode.UPSERT;
    private List<String> primaryKeys = List.of();

    public MongoItemWriterBuilder<T> mode(MongoItemWriter.Mode mode) {
        this.mode = mode;
        return this;
    }

    public MongoItemWriterBuilder<T> template(MongoOperations template) {
        this.template = template;
        return this;
    }

    public MongoItemWriterBuilder<T> collection(String collection) {
        this.collection = collection;
        return this;
    }

    public MongoItemWriterBuilder<T> primaryKeys(List<String> primaryKeys) {
        this.primaryKeys = List.copyOf(primaryKeys);
        return this;
    }

    public MongoItemWriterBuilder<T> primaryKeys(String ... primaryKeys) {
        this.primaryKeys = List.of(primaryKeys);
        return this;
    }

    public MongoItemWriter<T> build() {
        Assert.notNull((Object)this.template, (String)"template is required.");
        MongoItemWriter writer = new MongoItemWriter(this.template);
        writer.setMode(this.mode);
        writer.setCollection(this.collection);
        if (!this.primaryKeys.isEmpty()) {
            writer.setPrimaryKeys(this.primaryKeys);
        }
        return writer;
    }
}

