/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.xml.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.xml.StaxEventItemReader;
import org.springframework.core.io.Resource;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.StaxUtils;

public class StaxEventItemReaderBuilder<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private boolean strict = true;
    private @Nullable Resource resource;
    private @Nullable Unmarshaller unmarshaller;
    private final List<String> fragmentRootElements = new ArrayList<String>();
    private boolean saveState = true;
    private @Nullable String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;
    private XMLInputFactory xmlInputFactory = StaxUtils.createDefensiveInputFactory();
    private String encoding = StaxEventItemReader.DEFAULT_ENCODING;

    public StaxEventItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public StaxEventItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public StaxEventItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public StaxEventItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public StaxEventItemReaderBuilder<T> resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public StaxEventItemReaderBuilder<T> unmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
        return this;
    }

    public StaxEventItemReaderBuilder<T> addFragmentRootElements(String ... fragmentRootElements) {
        this.fragmentRootElements.addAll(Arrays.asList(fragmentRootElements));
        return this;
    }

    public StaxEventItemReaderBuilder<T> addFragmentRootElements(List<String> fragmentRootElements) {
        this.fragmentRootElements.addAll(fragmentRootElements);
        return this;
    }

    public StaxEventItemReaderBuilder<T> strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public StaxEventItemReaderBuilder<T> xmlInputFactory(XMLInputFactory xmlInputFactory) {
        this.xmlInputFactory = xmlInputFactory;
        return this;
    }

    public StaxEventItemReaderBuilder<T> encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public StaxEventItemReader<T> build() {
        Assert.notNull((Object)this.unmarshaller, (String)"An unmarshaller is required");
        StaxEventItemReader reader = new StaxEventItemReader(this.unmarshaller);
        if (this.resource != null) {
            reader.setResource(this.resource);
        } else {
            this.logger.debug((Object)"The resource is null. This is only a valid scenario when injecting resource later as in when using the MultiResourceItemReader");
        }
        if (this.saveState) {
            Assert.state((boolean)StringUtils.hasText((String)this.name), (String)"A name is required when saveState is set to true.");
        }
        Assert.notEmpty(this.fragmentRootElements, (String)"At least one fragment root element is required");
        if (this.name != null) {
            reader.setName(this.name);
        }
        reader.setSaveState(this.saveState);
        reader.setFragmentRootElementNames(this.fragmentRootElements.toArray(new String[0]));
        reader.setStrict(this.strict);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setXmlInputFactory(this.xmlInputFactory);
        reader.setEncoding(this.encoding);
        return reader;
    }
}

